using System;
using System.Net;
using System.Net.Sockets;
using Gtk;
using System.Text;

public partial class MainWindow : Gtk.Window
{
	public static System.Net.Sockets.Socket m_client;
	public byte[] m_buffer = new byte[100000];


	public MainWindow() : base(Gtk.WindowType.Toplevel)
	{
		Build();
	}

	protected void OnDeleteEvent(object sender, DeleteEventArgs a)
	{
		Gtk.Application.Quit();
		a.RetVal = true;
	}
	
	protected void OnConnectSocketClicked(object sender, EventArgs e)
	{

		_status.Text = "Connecting to Server...";

		string l_inputIP = _IPAddress.Text;
		IPAddress l_ipAddress;
		if (!IPAddress.TryParse(l_inputIP, out l_ipAddress))
		{
			System.Windows.Forms.MessageBox.Show($"{l_inputIP} is not an IP address!");
			return;
		}


		EndPoint l_endpoint = new IPEndPoint(l_ipAddress, 36000);

		m_client = new System.Net.Sockets.Socket(l_ipAddress.AddressFamily, SocketType.Stream, ProtocolType.Tcp);

		try
		{
			//Connect to socket
			//m_client.Connect(l_endpoint);
			IAsyncResult result = m_client.BeginConnect(l_ipAddress, 36000, null, null);
			bool success = result.AsyncWaitHandle.WaitOne(5000, true);

			if (m_client.Connected)
			{
				m_client.EndConnect(result);
				_status.Text = "Connected to DAQ PC.";
				_ConnectSocket.Sensitive = false;

				int l_b = m_client.Receive(m_buffer);

				_LocalLog.Buffer.Text += Encoding.ASCII.GetString(m_buffer, 0, l_b);
				_LocalLog.Buffer.Text += "\n";

				
				//Enable all buttons
				_AllStatus.Sensitive = true;
				_AllFirmware.Sensitive = true;
				_AllRunStatus.Sensitive = true;
				_SpillNumber.Sensitive = true;
				_AllMonitoring.Sensitive = true;
				_AppSettings.Sensitive = true;
				_SetRunProperties.Sensitive = true;
				_AllSync.Sensitive = true;
				_AllPrepareDAQ.Sensitive = false;
				_StartTrigger.Sensitive = false;
				_StopTrigger.Sensitive = false;
				_AllStopDAQ.Sensitive = false;
				_EnableButtons.Sensitive = true;
				_ContinuousMonitor.Sensitive = true;
				_ContinuousMonitorStop.Sensitive = true;
				_Exit.Sensitive = false;
				_Help.Sensitive = true;
			}
			else
			{
				m_client.Close();
				_status.Text = "Failed to connect to DAQ PC. \n";
				throw new ApplicationException("Failed to connect to server.");
			}
        }
		catch (Exception x_e)
		{
			_LocalLog.Buffer.Text += (x_e.ToString());
		}

        
	}

	protected void OnAllStatusClicked(object sender, EventArgs e)
	{
		Array.Clear(m_buffer, 0, m_buffer.Length);
		_LocalLog.Buffer.Text += "Command: Status of all FEBs:\n";
		m_client.Send(Encoding.ASCII.GetBytes("AllStatus"));

		int l_b = m_client.Receive(m_buffer);
		string l_msg = Encoding.ASCII.GetString(m_buffer, 0, l_b);
		_LocalLog.Buffer.Text += l_msg;
        _LocalLog.ScrollToIter(_LocalLog.Buffer.EndIter, 0, true, 0, 0);
    }

	protected void OnAllFirmwareClicked(object sender, EventArgs e)
	{
		Array.Clear(m_buffer, 0, m_buffer.Length);
		_LocalLog.Buffer.Text += "Command: Firmware of all FEBs:\n";
		m_client.Send(Encoding.ASCII.GetBytes("AllFirmware"));

		int l_b = m_client.Receive(m_buffer);
		string l_msg = Encoding.ASCII.GetString(m_buffer, 0, l_b);
		_LocalLog.Buffer.Text += l_msg;
        _LocalLog.ScrollToIter(_LocalLog.Buffer.EndIter, 0, true, 0, 0);
    }

	protected void OnAllRunStatusClicked(object sender, EventArgs e)
	{
		Array.Clear(m_buffer, 0, m_buffer.Length);
		_LocalLog.Buffer.Text += "Command: Run Status of all MCRs:\n";
		m_client.Send(Encoding.ASCII.GetBytes("AllRunStatus"));

		int l_b = m_client.Receive(m_buffer);
		string l_msg = Encoding.ASCII.GetString(m_buffer, 0, l_b);
		_LocalLog.Buffer.Text += l_msg;
        _LocalLog.ScrollToIter(_LocalLog.Buffer.EndIter, 0, true, 0, 0);
    }

	protected void OnSpillNumberClicked(object sender, EventArgs e)
	{
		Array.Clear(m_buffer, 0, m_buffer.Length);
		_LocalLog.Buffer.Text += "Command: Spill Number:\n";
		m_client.Send(Encoding.ASCII.GetBytes("GetSpillNumber"));

		int l_b = m_client.Receive(m_buffer);
		string l_msg = Encoding.ASCII.GetString(m_buffer, 0, l_b);
		_LocalLog.Buffer.Text += l_msg;
        _LocalLog.ScrollToIter(_LocalLog.Buffer.EndIter, 0, true, 0, 0);
    }

	protected void OnAllMonitoringClicked(object sender, EventArgs e)
	{
		Array.Clear(m_buffer, 0, m_buffer.Length);
		_LocalLog.Buffer.Text += "Command: Housekeeping values for all FEBs:\n";
		m_client.Send(Encoding.ASCII.GetBytes("AllMonitoring"));

		int l_b = m_client.Receive(m_buffer);
		string l_msg = Encoding.ASCII.GetString(m_buffer, 0, l_b);
		_LocalLog.Buffer.Text += l_msg;
        _LocalLog.ScrollToIter(_LocalLog.Buffer.EndIter, 0, true, 0, 0);

    }
	protected void OnAllSyncClicked(object sender, EventArgs e)
	{
		Array.Clear(m_buffer, 0, m_buffer.Length);
		_LocalLog.Buffer.Text += "Command: All SYNC:\n";
		m_client.Send(Encoding.ASCII.GetBytes("AllSYNC"));

		int l_b = m_client.Receive(m_buffer);
		string l_msg = Encoding.ASCII.GetString(m_buffer, 0, l_b);
		_LocalLog.Buffer.Text += l_msg;
		_LocalLog.ScrollToIter(_LocalLog.Buffer.EndIter, 0, true, 0, 0);

		_AllSync.Sensitive = false;
		_AllPrepareDAQ.Sensitive = true;
	}

	protected void OnAllPrepareDAQClicked(object sender, EventArgs e)
	{
		Array.Clear(m_buffer, 0, m_buffer.Length);
		_LocalLog.Buffer.Text += "Command: Prepare all FEBs for data taking.\n";
		_AllPrepareDAQ.Sensitive = false;
		_StartTrigger.Sensitive = true;

		m_client.Send(Encoding.ASCII.GetBytes("AllPrepareDAQ"));

		int l_b = m_client.Receive(m_buffer);
		string l_msg = Encoding.ASCII.GetString(m_buffer, 0, l_b);
		_LocalLog.Buffer.Text += l_msg;
        _LocalLog.ScrollToIter(_LocalLog.Buffer.EndIter, 0, true, 0, 0);

        //DAQ status label
        _DAQstatus.LabelProp = "***Taking Data...Waiting for trigger***";
    }

	protected void OnStartTriggerClicked(object sender, EventArgs e)
	{
		Array.Clear(m_buffer, 0, m_buffer.Length);
		_LocalLog.Buffer.Text += "Command: Start the Trigger.\n";
		_StartTrigger.Sensitive = false;
		_StopTrigger.Sensitive = true;

		m_client.Send(Encoding.ASCII.GetBytes("StartTrigger"));

		int l_b = m_client.Receive(m_buffer);
		string l_msg = Encoding.ASCII.GetString(m_buffer, 0, l_b);
		_LocalLog.Buffer.Text += l_msg;
        _LocalLog.ScrollToIter(_LocalLog.Buffer.EndIter, 0, true, 0, 0);

        //DAQ status label
        _DAQstatus.LabelProp = "***Taking Data...***";
    }

	protected void OnStopTriggerClicked(object sender, EventArgs e)
	{
		Array.Clear(m_buffer, 0, m_buffer.Length);
		_LocalLog.Buffer.Text += "Command: Stop the Trigger.\n";
        _StopTrigger.Sensitive = false;
        _AllStopDAQ.Sensitive = true;

        m_client.Send(Encoding.ASCII.GetBytes("StopTrigger"));

		int l_b = m_client.Receive(m_buffer);
		string l_msg = Encoding.ASCII.GetString(m_buffer, 0, l_b);
		_LocalLog.Buffer.Text += l_msg;
        _LocalLog.ScrollToIter(_LocalLog.Buffer.EndIter, 0, true, 0, 0);

        //DAQ status label
        _DAQstatus.LabelProp = "***Trigger is stopped...Waiting to Stop DAQ***";
    }

	protected void OnAllStopDAQClicked(object sender, EventArgs e)
	{
		Array.Clear(m_buffer, 0, m_buffer.Length);
		_LocalLog.Buffer.Text += "Command: Stop the DAQ on all FEBs.\n";
		_AllStopDAQ.Sensitive = false;
		_AllPrepareDAQ.Sensitive = true;

		m_client.Send(Encoding.ASCII.GetBytes("AllStopDAQ"));

		int l_b = m_client.Receive(m_buffer);
		string l_msg = Encoding.ASCII.GetString(m_buffer, 0, l_b);
		_LocalLog.Buffer.Text += l_msg;
        _LocalLog.ScrollToIter(_LocalLog.Buffer.EndIter, 0, true, 0, 0);

        //DAQ status label
        _DAQstatus.LabelProp = "***No running data***";
    }

	protected void OnEnableButtonsCliked(object sender, EventArgs e)
	{
		_AllSync.Sensitive = true;
		_AllPrepareDAQ.Sensitive = true;
        _StartTrigger.Sensitive = true;
        _StopTrigger.Sensitive = true;
        _AllStopDAQ.Sensitive = true;

		_Exit.Sensitive = true;
    }
	protected void OnExitClicked(object sender, EventArgs e)
	{
		Array.Clear(m_buffer, 0, m_buffer.Length);
		_LocalLog.Buffer.Text += "Command: Exit DAQ application and communication socket.\n";
		m_client.Send(Encoding.ASCII.GetBytes("Exit"));

		int l_b = m_client.Receive(m_buffer);
		string l_msg = Encoding.ASCII.GetString(m_buffer, 0, l_b);
		_LocalLog.Buffer.Text += l_msg;
        _LocalLog.ScrollToIter(_LocalLog.Buffer.EndIter, 0, true, 0, 0);

        //Enable connect button
        _ConnectSocket.Sensitive = true;
		_status.Text = "Not Connected to DAQ PC";
		_DAQstatus.LabelProp = "Unknown";

        //disable all other buttons
        _AllStatus.Sensitive = false;
        _AllFirmware.Sensitive = false;
        _AllRunStatus.Sensitive = false;
        _SpillNumber.Sensitive = false;
        _AllMonitoring.Sensitive = false;
        _AppSettings.Sensitive = false;
        _SetRunProperties.Sensitive = false;
		_AllSync.Sensitive = false;
        _AllPrepareDAQ.Sensitive = false;
        _StartTrigger.Sensitive = false;
        _StopTrigger.Sensitive = false;
        _AllStopDAQ.Sensitive = false;
		_EnableButtons.Sensitive = false;
        _ContinuousMonitor.Sensitive = false;
        _ContinuousMonitorStop.Sensitive = false;
        _Exit.Sensitive = false;
        _Help.Sensitive = false;

    }

	protected void OnHelpClicked(object sender, EventArgs e)
	{
		Array.Clear(m_buffer, 0, m_buffer.Length);
		_LocalLog.Buffer.Text += "Command: Help:\n";
		m_client.Send(Encoding.ASCII.GetBytes("Help"));

		int l_b = m_client.Receive(m_buffer);
		string l_msg = Encoding.ASCII.GetString(m_buffer, 0, l_b);
		_LocalLog.Buffer.Text += l_msg;
        _LocalLog.ScrollToIter(_LocalLog.Buffer.EndIter,0,true,0,0) ;

    }

	protected void OnSetRunPropertiesClicked(object sender, EventArgs e)
	{
		Array.Clear(m_buffer, 0, m_buffer.Length);
		_LocalLog.Buffer.Text += "Command: Set Run Number and Run Type.\n";
		m_client.Send(Encoding.ASCII.GetBytes("SetRunProperties " + _EntryRunNumber.Text + " " + _EntryRunType.Text));

		int l_b = m_client.Receive(m_buffer);
		string l_msg = Encoding.ASCII.GetString(m_buffer, 0, l_b);
		_LocalLog.Buffer.Text += l_msg;
        _LocalLog.ScrollToIter(_LocalLog.Buffer.EndIter, 0, true, 0, 0);
    }

	protected void OnAppSettingsClicked(object sender, EventArgs e)
	{
		Array.Clear(m_buffer, 0, m_buffer.Length);
		_LocalLog.Buffer.Text += "Command: DAQ App-Settings:\n";
		m_client.Send(Encoding.ASCII.GetBytes("GetAppSettings"));

		int l_b = m_client.Receive(m_buffer);
		string l_msg = Encoding.ASCII.GetString(m_buffer, 0, l_b);
		_LocalLog.Buffer.Text += l_msg;
        _LocalLog.ScrollToIter(_LocalLog.Buffer.EndIter, 0, true, 0, 0);
    }

	protected void OnSaveLogClicked(object sender, EventArgs e)
	{
		bool exists = System.IO.Directory.Exists("Log");

		if (!exists)
			System.IO.Directory.CreateDirectory("Log");
		System.IO.File.WriteAllText(@"Log/GUILog_" + string.Format("{0:yyyy_MM_dd_HH_mm_ss}", DateTime.Now) + ".txt", _LocalLog.Buffer.Text);

	}

	protected void OnClearLogClicked(object sender, EventArgs e)
	{
		_LocalLog.Buffer.Text = "";
	}

	protected void OnContinuousMonitorClicked(object sender, EventArgs e)
	{
		Array.Clear(m_buffer, 0, m_buffer.Length);
		_LocalLog.Buffer.Text += "Command: Start Monitoring Data.\n";
		m_client.Send(Encoding.ASCII.GetBytes("StartStopMonitoringData /start"));

		int l_b = m_client.Receive(m_buffer);
		string l_msg = Encoding.ASCII.GetString(m_buffer, 0, l_b);
		_LocalLog.Buffer.Text += l_msg;
        _LocalLog.ScrollToIter(_LocalLog.Buffer.EndIter, 0, true, 0, 0);
    }

	protected void OnContinuousMonitorStopClicked(object sender, EventArgs e)
	{
		Array.Clear(m_buffer, 0, m_buffer.Length);
		_LocalLog.Buffer.Text += "Command: Stop Monitoring Data.\n";
		m_client.Send(Encoding.ASCII.GetBytes("StartStopMonitoringData /stop"));

		int l_b = m_client.Receive(m_buffer);
		string l_msg = Encoding.ASCII.GetString(m_buffer, 0, l_b);
		_LocalLog.Buffer.Text += l_msg;
        _LocalLog.ScrollToIter(_LocalLog.Buffer.EndIter, 0, true, 0, 0);
    }

	/*public bool flag_CM;
	public static System.Timers.Timer _timer;
	public BabyMind.DAQ.MonitoringData.Data Monitoring_data = new BabyMind.DAQ.MonitoringData.Data();

	protected void OnContinuousMonitorClicked(object sender, EventArgs e)
	{
		_ContinuousMonitor.Sensitive = false;
		_ContinuousMonitorStop.Sensitive = true;
		//Timer
		//System.Threading.Thread.Sleep(500);
		_timer = new System.Timers.Timer();
		_timer.Elapsed += Refresh;
		_timer.Interval = 15000;
		_timer.Enabled = true;
		_timer.Start();
		//--------


	}

	void Refresh(object sender, System.Timers.ElapsedEventArgs e)
	{
		_timer.Stop();

		string _ans = Send_Receive("GetMonitoringData");
		//System.Threading.Thread.Sleep(2000);
		//_LocalLog.Buffer.Text += _ans;
		Monitoring_data = BabyMind.DAQ.MonitoringData.ReadDataFromString(_ans);
		//System.Threading.Thread.Sleep(1000);

		//Filling the display variables
		_Spill_num.LabelProp = Monitoring_data.MCB.MCBMode + ;
		_MCR_label.LabelProp = "MCR " + Monitoring_data.MCRs[0].MCR_num;
		_Filename.LabelProp = Monitoring_data.MCRs[0].File_name;
		_TimeElapsed.LabelProp = Monitoring_data.MCRs[0].Elapsed_time;
		_Filesize.LabelProp = Monitoring_data.MCRs[0].File_size.ToString();
		_DataRate.LabelProp = Monitoring_data.MCRs[0].Avg_rate.ToString();
		_MaxRate.LabelProp = Monitoring_data.MCRs[0].Max_rate.ToString();

		//Board
		_ASIC0_.LabelProp = Monitoring_data.MCRs[0].Boards[0].ASIC0_temp.ToString();
		_ASIC1_.LabelProp = Monitoring_data.MCRs[0].Boards[0].ASIC1_temp.ToString();
		_ASIC2_.LabelProp = Monitoring_data.MCRs[0].Boards[0].ASIC2_temp.ToString();
		_FPGA_.LabelProp = Monitoring_data.MCRs[0].Boards[0].FPGA_temp.ToString();
		_BOARDT_.LabelProp = Monitoring_data.MCRs[0].Boards[0].Board_temp.ToString();
		_HUMIDITY_.LabelProp = Monitoring_data.MCRs[0].Boards[0].Humidity.ToString();
		_HV_.LabelProp = Monitoring_data.MCRs[0].Boards[0].HV.ToString();

		//Fifo
		if (Monitoring_data.MCRs[0].Boards[0].L0FifoErr)
		{
			_L0Fifo.Text = "Err";
		}
		else
		{
			_L0Fifo.Text = "-";
		}
		if (Monitoring_data.MCRs[0].Boards[0].L1FifoErr) {
			_L1Fifo.Text = "Err";
		}
		else {
			_L1Fifo.Text = "-";
		}
		if (Monitoring_data.MCRs[0].Boards[0].L2FifoErr)
		{
			_L2Fifo.Text = "Err";
		}
		else
		{
			_L2Fifo.Text = "-";
		}

		//ErrorCounters
		_FSYNC_.LabelProp = Monitoring_data.MCRs[0].Boards[0].FSYNC_Err.ToString();
		_GTRIG_.LabelProp = Monitoring_data.MCRs[0].Boards[0].GTRIG_LOST.ToString();
		_PLL_.LabelProp = Monitoring_data.MCRs[0].Boards[0].PLL_LOCKED.ToString();
		_PARITY_.LabelProp = Monitoring_data.MCRs[0].Boards[0].PARITY_EOF.ToString();

		
		_timer.Start();

	}
	protected void OnContinuousMonitorStopClicked(object sender, EventArgs e)
	{
		_ContinuousMonitor.Sensitive = true;
		_ContinuousMonitorStop.Sensitive = false;
		_timer.Stop();
		_timer.Enabled = false;

		//Maybe close timer
	}

	private string Send_Receive(string command)
	{
 
		m_client.Send(Encoding.ASCII.GetBytes(command));

		Array.Clear(l_buffer, 0, l_buffer.Length);
		int l_b = m_client.Receive(l_buffer);
		string l_msg = Encoding.ASCII.GetString(l_buffer, 0, l_b);

		return l_msg;
	}*/

	
}
