﻿using System;
using System.IO.Ports;
using System.Diagnostics;

public static class StringExt
{
	public static string Truncate(this string value, int maxLength)
	{
		if (string.IsNullOrEmpty(value)) return value;
		return value.Length <= maxLength ? value : value.Substring(0, maxLength);
	}
	public static string Tail(this string value, int pos)
	{
		if (string.IsNullOrEmpty(value)) return value;
		return value.Length <= pos ? value : value.Substring(pos);
	}
}

namespace BabyMind.DAQ
{
	static public class MCB
	{
		static readonly int Delay = 100;

		public static int SendCommand (SerialPort _serialPort, string command)
		{
			_serialPort.Write(command);
			System.Threading.Thread.Sleep(Delay);
			int bytesRead = -1;
			try
			{
				byte[] data = new byte[command.Length];
				bytesRead = _serialPort.Read(data, 0, data.Length);
				Debug.Indent();
				Debug.WriteLine("Read {0} bytes", bytesRead);
				string reply = System.Text.Encoding.ASCII.GetString(data, 0, bytesRead);
				Debug.WriteLine(reply);
				Debug.Unindent();
				if (command != reply)
				{
					throw new System.IO.IOException(reply);
				}
			}
			catch (Exception e)
			{
				Console.WriteLine("Received error '{0}' while sending command '{1}'", e, command);
				return -1;
			}
			return bytesRead;
		}

		public static string SendQuery(SerialPort _serialPort, string query)
		{
			_serialPort.Write(query);
			System.Threading.Thread.Sleep(Delay);
			string reply = null;
			try
			{
				byte[] data = new byte[128];
				int bytesRead = _serialPort.Read(data, 0, data.Length);
				Debug.Indent();
				Debug.WriteLine("Read {0} bytes", bytesRead);
				reply = System.Text.Encoding.ASCII.GetString(data, 0, bytesRead);
				Debug.WriteLine(reply);
				Debug.Unindent();
				if ( query != reply.Truncate(query.Length) )
				{
					throw new System.IO.IOException(reply);
				}
			}
			catch (Exception e)
			{
				Console.WriteLine("Received error '{0}' while sending query '{1}'", e, query);
				return null;
			}
			return reply.Tail(3);
		}
	}
}