using System;
using System.IO;
using System.Collections.Generic;
using Newtonsoft.Json;


namespace BabyMind.DAQ
{
	/// <summary>
	/// JSON Monitoring data class, Data structure & methods to read/write
	/// </summary>
	public class MonitoringData
	{
		/// <summary>
		/// JSON Monitoring Data structure
		/// </summary>        
		public class Data
		{
			public List<MCR> MCRs = new List<MCR>();
			public MCBinfo MCB = new MCBinfo();

			/// <summary>
			/// MCB class
			/// </summary>
			public class MCBinfo
			{
				[JsonProperty("MCBM")]
				public string MCBMode = "";
				[JsonProperty("SN")]
				public int SpillNumber = 0;
			}

			/// <summary>
			/// MCR class
			/// </summary>
			public class MCR
			{
				[JsonProperty("ET")]
				public bool EnableThread = true;

				[JsonProperty("BIS")]
				public byte BoardIDStart = 0;
				[JsonProperty("BIE")]
				public byte BoardIDEnd = 0;

				[JsonProperty("NUM")]
				public int MCR_num =0;
				[JsonProperty("FN")]
				public string File_name ="test.daq";
				[JsonProperty("ETI")]
				public string Elapsed_time="0";
				[JsonProperty("FS")]
				public int File_size = 0;
				[JsonProperty("AR")]
				public int Avg_rate = 0;
				[JsonProperty("MR")]
				public int Max_rate = 0;
				[JsonProperty("Tr")]
				public bool IsTransferingData = false;

				public List<Board> Boards = new List<Board>();

			}
			/// <summary>
			/// JSON Board parameters
			/// </summary>
			public class Board
			{
				[JsonProperty("BID")]
				public int BoardID = 0;

				//HKB
				/* ASIC output has a bug so temp. read is wrong
                [JsonProperty("A0T")]
				public float ASIC0_temp = 0;
				[JsonProperty("A1T")]
				public float ASIC1_temp = 0;
				[JsonProperty("A2T")]
				public float ASIC2_temp = 0;*/
				[JsonProperty("FT")]
				public float FPGA_temp = 0;
				[JsonProperty("BT")]
				public float Board_temp = 0;
				[JsonProperty("HR")]
				public float Humidity = 0;
				[JsonProperty("HV")]
				public float HV = 0;

				//STATUS
				[JsonProperty("L0E")]
				public bool L0FifoErr = false;
				[JsonProperty("L1E")]
				public bool L1FifoErr = false;
				[JsonProperty("L2E")]
				public bool L2FifoErr = false;

				//Error counter
				[JsonProperty("FSE")]
				public byte FSYNC_Err = 0;
				[JsonProperty("GLE")]
				public byte GTRIG_LOST = 0;
				[JsonProperty("PLE")]
				public byte PLL_LOCKED = 0;
				[JsonProperty("PAE")]
				public byte PARITY_EOF = 0;

				/// <summary>
				/// Clear all variable to default values
				/// </summary>
				public void Clear()
				{
					BoardID = 0;
					/*ASIC0_temp = 0;
					ASIC1_temp = 0;
					ASIC2_temp = 0;*/
					FPGA_temp = 0;
					Board_temp = 0;
					Humidity = 0;
					HV = 0;

					//STATUS
					L0FifoErr = false;
					L1FifoErr = false;
					L2FifoErr = false;

					//Error counter
					FSYNC_Err = 0;
					GTRIG_LOST = 0;
					PLL_LOCKED = 0;
					PARITY_EOF = 0;
				}
			}
		}

        public class ReducedData
        {
            public List<MCR> MCRs = new List<MCR>();
            public MCBinfo MCB = new MCBinfo();

            /// <summary>
			/// MCB class
			/// </summary>
            public class MCBinfo
            {
                [JsonProperty("SpillNumber")]
                public int SpillNumber = 0;

				

            }
            /// <summary>
			/// MCR class
			/// </summary>
            public class MCR
			{
				[JsonProperty("IsTr?")]
				public bool IsTransferingData = false;

				[JsonProperty("FileSize")]
                public int File_size = 0;
			}

        }
            /// <summary>
            /// Read Data from a string
            /// </summary>
            static public Data ReadDataFromString(string x_jsonString) 
		{
			return JsonConvert.DeserializeObject<Data>(x_jsonString);
		}

		/// <summary>
		/// Write Data to a string
		/// </summary>
		static public string WriteDataToString(Data x_data)
		{
			return JsonConvert.SerializeObject(x_data, Formatting.None);
		}

        ////
        /// <summary>
        /// Read reduced Data from a string
        /// </summary>
        static public ReducedData ReadReducedDataFromString(string x_jsonString)
        {
            return JsonConvert.DeserializeObject<ReducedData>(x_jsonString);
        }

        /// <summary>
        /// Write Data to a string
        /// </summary>
        static public string WriteReducedDataToString(ReducedData x_data)
        {
            return JsonConvert.SerializeObject(x_data, Formatting.None);
        }
    }



}
