﻿using System;
using System.Xml.Linq;
using System.Collections.Generic;

namespace BabyMind.DAQ
{
    public class XMLDecoder
    {
        protected List<string> ArgsList = new List<string>();
        public XMLDecoder(string x_buf)
        {
            try
            {
                XElement l_Cmd = XElement.Parse(x_buf);
                if (l_Cmd.IsEmpty)
                {
                    throw new System.Xml.XmlException("XML command is empty");
                }
                if (l_Cmd.Name != "cmd")
                {
                    throw new System.Xml.XmlException("XML command has no cmd element");
                }
                if ((CmdName = l_Cmd.Attribute("name").Value) == null)
                {
                    throw new System.Xml.XmlException("XML command has no \"name\" attribute");
                }
                IEnumerable<XElement> l_AllParams = l_Cmd.Elements("param");
                foreach (XElement l_Param in l_AllParams)
                {
                    if (!l_Param.IsEmpty)
                    {
                        ArgsList.Add(l_Param.Value);
                    }
                }
                Args = ArgsList.ToArray();
                NumArgs = ArgsList.Count;
            }
            catch (System.Xml.XmlException e)
            {
                Console.WriteLine(e.Message);
            }
        }
        public string CmdName { get; }
        public string[] Args { get; }
        public int NumArgs { get; }
    }
}
