<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">

  <xsl:template name="redundantSystemInfo" match="/">
    <h1><xsl:value-of select="extensions:getString('IDS_REDUNDANT_GROUP_INFORMATION_HEADER')" disable-output-escaping="yes"/></h1>
    <table class="systemInfoTable">
      <tr>
        <th><xsl:value-of select="extensions:getString('IDS_QUORUM_STATE_LABEL')" disable-output-escaping="yes"/></th>
        <td><xsl:value-of select="//fnplm:redundant/@quorumState"/></td>
      </tr>
      <tr>
        <th><xsl:value-of select="extensions:getString('IDS_MASTER_LABEL')" disable-output-escaping="yes"/></th>
        <td><xsl:value-of select="//fnplm:redundant/@master"/></td>
      </tr>
      <tr>
        <th><xsl:value-of select="extensions:getString('IDS_TIMEOUT_LABEL')" disable-output-escaping="yes"/></th>
        <td><xsl:value-of select="//fnplm:redundant/@timeout"/></td>
      </tr>
      <tr>
        <th><xsl:value-of select="extensions:getString('IDS_PRIMARY_IS_MASTER_LABEL')" disable-output-escaping="yes"/></th>
        <td><xsl:value-of select="//fnplm:redundant/@primaryIsMaster"/></td>
      </tr>
    </table><br/>
    <table class="redundantInfoTable" width="50%">
      <tr>
        <th width="10%"><xsl:value-of select="extensions:getString('IDS_HOST_TABLE_HEADER')" disable-output-escaping="yes"/></th>
        <th width="10%"><xsl:value-of select="extensions:getString('IDS_PORT_TABLE_HEADER')" disable-output-escaping="yes"/></th>
        <th width="10%"><xsl:value-of select="extensions:getString('IDS_STATUS_TABLE_HEADER')" disable-output-escaping="yes"/></th>
      </tr>
      <xsl:apply-templates select="//fnplm:member"/>
    </table>
  </xsl:template>
   <xsl:template name="hostItem" match="//fnplm:member">
     <tr>
       <td><xsl:value-of select="./@hostName"/></td>
       <td><xsl:value-of select="./@port"/></td>
       <td><xsl:value-of select="./@state"/></td>
     </tr>
   </xsl:template>
</xsl:stylesheet>
