<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:param name="vendor"><xsl:value-of select="//fnplm:input/@vendor"/></xsl:param>
  <xsl:param name="productId"><xsl:value-of select="//fnplm:input/@productId"/></xsl:param>
  <xsl:param name="feature"><xsl:value-of select="//fnplm:input/@feature"/></xsl:param>
  <xsl:param name="version"><xsl:value-of select="//fnplm:input/@version"/></xsl:param>
  <xsl:param name="host"><xsl:value-of select="//fnplm:input/@host"/></xsl:param>
  <xsl:param name="sortAttr">
    <xsl:choose>
      <xsl:when test="//fnplm:input/@sortAttr!=''">@<xsl:value-of select="//fnplm:input/@sortAttr"/></xsl:when>
      <xsl:otherwise>@<xsl:value-of select="$defaultSortAttribute"/></xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  <xsl:param name="sortDir">
    <xsl:choose>
      <xsl:when test="//fnplm:input/@sortDir!=''">
        <xsl:value-of select="//fnplm:input/@sortDir"/>
      </xsl:when>
      <xsl:otherwise>ascending</xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  <xsl:param name="pageOffset">
    <xsl:choose>
      <xsl:when test="//fnplm:input/@pageOffset!=''">
        <xsl:value-of select="//fnplm:input/@pageOffset"/>
      </xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  <xsl:param name="pageSize">
    <xsl:choose>
      <xsl:when test="//fnplm:input/@pageSize!=''">
        <xsl:value-of select="//fnplm:input/@pageSize"/>
      </xsl:when>
      <xsl:otherwise>1</xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  <xsl:param name="searchCriteria"><xsl:value-of select="//fnplm:input/@searchCriteria"/></xsl:param>
  
  <xsl:template match="/" name="details">
    <xsl:text disable-output-escaping="yes">&lt;!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"&gt;</xsl:text>
    <html>
      <head>
        <title>
          <xsl:choose>
            <xsl:when test="$details='HOSTS'">
              <xsl:value-of select="extensions:getString('IDS_HOSTS_TITLE')" disable-output-escaping="yes"/>
            </xsl:when>
            <xsl:when test="$details='FULFILLMENTS'">
              <xsl:value-of select="extensions:getString('IDS_FULFILLMENTS_TITLE')" disable-output-escaping="yes"/>
            </xsl:when>
            <xsl:when test="$details='CONCURRENT_HOSTS'">
              <xsl:value-of select="extensions:getString('IDS_CONCURRENT_HOSTS_TITLE')" disable-output-escaping="yes"/>
            </xsl:when>
            <xsl:when test="$details='HOST'">
              <xsl:value-of select="extensions:getString('IDS_HOST_TITLE')" disable-output-escaping="yes"/>
            </xsl:when>
          </xsl:choose>
        </title>
        
        <xsl:choose>
          <xsl:when test="$compliance508!='TRUE'">
            <style> html{display : none ; } </style>
            <script>
              if( self == top ) {
                  document.documentElement.style.display = 'block' ; 
              } else {
                  top.location = self.location ; 
              }
            </script>
            <link rel="stylesheet" type="text/css" href="resources/content.css"/>
            <link rel="stylesheet" type="text/css" href="resources/structure.css"/>
            <link rel="stylesheet" type="text/css" href="resources/veneer.css"/>
            <link rel="stylesheet" type="text/css" href="resources/veneerPopup.css"/>
          </xsl:when>
          <xsl:otherwise>
            <link rel="stylesheet" type="text/css" href="resources/508/content.css"/>
            <link rel="stylesheet" type="text/css" href="resources/508/structure.css"/>
            <link rel="stylesheet" type="text/css" href="resources/508/veneer.css"/>
            <link rel="stylesheet" type="text/css" href="resources/508/veneerPopup.css"/>
          </xsl:otherwise>
        </xsl:choose>
        <script type="text/javascript" src="resources/standard.js"></script>
        <script type="text/javascript" src="resources/ajax.js"></script>
        <script type="text/javascript" src="resources/tableSorter.js"></script>
        <script type="text/javascript" src="resources/yahoofiles/yp_files/yahoo.js" ></script>
        <script type="text/javascript" src="resources/yahoofiles/yp_files/event.js" ></script>
        <script type="text/javascript" src="resources/yahoofiles/yp_files/dom.js" ></script>
        <script type="text/javascript" src="resources/yahoofiles/yp_files/dragdrop.js" ></script>
        <script type="text/javascript" src="resources/yahoofiles/yp_files/animation.js" ></script>
        <script type="text/javascript" src="resources/yahoofiles/yp_files/container.js"></script>
      
        <meta http-equiv="Cache-Control" content="no-cache"/>
        <meta http-equiv="Pragma" content="no-cache"/>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <script language="javascript">
          function showExport() {
            document.location.href = "/export?details=<xsl:value-of select="$details"/>&amp;vendor=<xsl:value-of select="$vendor"/>&amp;productId=<xsl:value-of select="$productId"/>&amp;feature=<xsl:value-of select="$feature"/>&amp;version=<xsl:value-of select="$version"/>&amp;host=<xsl:value-of select="$host"/>";
            return false;
          }
        </script>
      </head>

      <body>
        <div class="containerCenter">
          <div class="contentSpacer">
            <div id="leftContent">
              <p></p>
              <h1>
                <xsl:choose>
                  <xsl:when test="$details='HOSTS'">
                    <xsl:value-of select="extensions:getString('IDS_HOSTS_HEADER')" disable-output-escaping="yes"/>
                  </xsl:when>
                  <xsl:when test="$details='FULFILLMENTS'">
                    <xsl:value-of select="extensions:getString('IDS_FULFILLMENTS_HEADER')" disable-output-escaping="yes"/>
                  </xsl:when>
                  <xsl:when test="$details='CONCURRENT_HOSTS'">
                    <xsl:value-of select="extensions:getString('IDS_CONCURRENT_HOSTS_HEADER')" disable-output-escaping="yes"/>
                  </xsl:when>
                  <xsl:when test="$details='HOST'">
                    <xsl:value-of select="extensions:getString('IDS_HOST_HEADER')" disable-output-escaping="yes"/>
                  </xsl:when>
                </xsl:choose>
              </h1>
              <p></p>
              <div id="buttons" style="float: right;">
              <xsl:text disable-output-escaping="yes">&lt;</xsl:text>form action="/export" method="get"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="details" value="<xsl:value-of select="$details"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="vendor" value="<xsl:value-of select="$vendor"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="productId" value="<xsl:value-of select="$productId"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="feature" value="<xsl:value-of select="$feature"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="version" value="<xsl:value-of select="$version"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="host" value="<xsl:value-of select="$host"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="submit" name="ExportData" value="Export Data" class="button" onmouseover="this.className='button buttonHover'" onmouseout="this.className='button'" onclick="showExport()" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/form<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
              </div>
              <xsl:param name="detailsReturn">
                <xsl:choose>
                  <xsl:when test="$searchCriteria=''">
                    <xsl:choose>
                      <xsl:when test="$details='HOSTS'">
                        <xsl:value-of select="extensions:getHostSummary($vendor, $productId, $pageOffset, $sortAttr, $sortDir, 'xslt/hostsDetails.xsl')" disable-output-escaping="yes" />
                      </xsl:when>
                      <xsl:when test="$details='FULFILLMENTS'">
                        <xsl:value-of select="extensions:getFulfillmentSummary($vendor, $productId, $pageOffset, $sortAttr, $sortDir, 'xslt/fulfillmentsDetails.xsl')" disable-output-escaping="yes" />
                      </xsl:when>
                      <xsl:when test="$details='CONCURRENT_HOSTS'">
                        <xsl:value-of select="extensions:getUserSummary($vendor, $feature, $version, $sortAttr, $sortDir, $pageOffset, 'xslt/concurrentHostsDetails.xsl')" disable-output-escaping="yes" />
                      </xsl:when>
                      <xsl:when test="$details='HOST'">
                        <xsl:value-of select="extensions:getHost($vendor, $host, 'xslt/hostDetails.xsl')" disable-output-escaping="yes" />
                      </xsl:when>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:choose>
                      <xsl:when test="$details='HOSTS'">
                        <xsl:value-of select="extensions:searchHost($vendor, $productId, $searchCriteria, 'xslt/hostsDetails.xsl')" disable-output-escaping="yes" />
                      </xsl:when>
                      <xsl:when test="$details='FULFILLMENTS'">
                        <xsl:value-of select="extensions:searchFulfillment($vendor, $productId, $searchCriteria, 'xslt/fulfillmentsDetails.xsl')" disable-output-escaping="yes" />
                      </xsl:when>
                      <xsl:when test="$details='CONCURRENT_HOSTS'">
                        <xsl:value-of select="extensions:searchUser($vendor, $feature, $version, $searchCriteria, 'xslt/concurrentHostsDetails.xsl')" disable-output-escaping="yes" />
                      </xsl:when>
                      <xsl:when test="$details='HOST'">
                        <xsl:value-of select="extensions:getHost($vendor, $host, 'xslt/hostDetails.xsl')" disable-output-escaping="yes" />
                      </xsl:when>
                    </xsl:choose>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:param>
              <xsl:choose>
                <xsl:when test="starts-with($detailsReturn, 'ERROR_EXPIRED_SESSION:')">
                  <xsl:call-template name="sessionTimeout"/>
                </xsl:when>
                <xsl:when test="$detailsReturn != ''">
                  <xsl:copy-of select="$detailsReturn"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:copy-of select="$detailsReturn"/>
                </xsl:otherwise>
              </xsl:choose>
            </div>
          </div>
        </div>
        <script type="text/javascript">
          <xsl:choose>
            <xsl:when test="$details='HOSTS'">
              <xsl:param name="nameSort">
                <xsl:choose>
                  <xsl:when test="$sortAttr='@name' and $sortDir='descending'">SD</xsl:when>
                  <xsl:when test="$sortAttr='@name' and $sortDir='ascending'">S</xsl:when>
                  <xsl:otherwise>false</xsl:otherwise>
                </xsl:choose>
              </xsl:param>
              <xsl:param name="fulfillmentSort">
                <xsl:choose>
                  <xsl:when test="$sortAttr='@originalfulfillmentid' and $sortDir='descending'">SD</xsl:when>
                  <xsl:when test="$sortAttr='@originalfulfillmentid' and $sortDir='ascending'">S</xsl:when>
                  <xsl:otherwise>false</xsl:otherwise>
                </xsl:choose>
              </xsl:param>
              initTableWidget('myTable',580,345,Array(false,'<xsl:value-of select="$nameSort"/>','<xsl:value-of select="$fulfillmentSort"/>'));
            </xsl:when>
            <xsl:when test="$details='FULFILLMENTS'">
              <xsl:param name="fulfillmentSort">
                <xsl:choose>
                  <xsl:when test="$sortAttr='@fulfillmentid' and $sortDir='descending'">SD</xsl:when>
                  <xsl:when test="$sortAttr='@fulfillmentid' and $sortDir='ascending'">S</xsl:when>
                  <xsl:otherwise>false</xsl:otherwise>
                </xsl:choose>
              </xsl:param>
              <xsl:param name="quantitySort">
                <xsl:choose>
                  <xsl:when test="$sortAttr='@activatablecount' and $sortDir='descending'">SD</xsl:when>
                  <xsl:when test="$sortAttr='@activatablecount' and $sortDir='ascending'">S</xsl:when>
                  <xsl:otherwise>false</xsl:otherwise>
                </xsl:choose>
              </xsl:param>
              <xsl:param name="expirationSort">
                <xsl:choose>
                  <xsl:when test="$sortAttr='@expiration' and $sortDir='descending'">SD</xsl:when>
                  <xsl:when test="$sortAttr='@expiration' and $sortDir='ascending'">S</xsl:when>
                  <xsl:otherwise>false</xsl:otherwise>
                </xsl:choose>
              </xsl:param>
              <xsl:param name="serverSort">
                <xsl:choose>
                  <xsl:when test="$sortAttr='@activationchain' and $sortDir='descending'">SD</xsl:when>
                  <xsl:when test="$sortAttr='@activationchain' and $sortDir='ascending'">S</xsl:when>
                  <xsl:otherwise>false</xsl:otherwise>
                </xsl:choose>
              </xsl:param>
              <xsl:param name="repairSort">
                <xsl:choose>
                  <xsl:when test="$sortAttr='@repaircount' and $sortDir='descending'">SD</xsl:when>
                  <xsl:when test="$sortAttr='@repaircount' and $sortDir='ascending'">S</xsl:when>
                  <xsl:otherwise>false</xsl:otherwise>
                </xsl:choose>
              </xsl:param>
              initTableWidget('myTable',580,345,Array(false,'<xsl:value-of select="$fulfillmentSort"/>','<xsl:value-of select="$quantitySort"/>','<xsl:value-of select="$expirationSort"/>', false,'<xsl:value-of select="$serverSort"/>','<xsl:value-of select="$repairSort"/>'));
            </xsl:when>
            <xsl:when test="$details='CONCURRENT_HOSTS'">
              <xsl:param name="hostSort">
                <xsl:choose>
                  <xsl:when test="$sortAttr='@hostname' and $sortDir='descending'">SD</xsl:when>
                  <xsl:when test="$sortAttr='@hostname' and $sortDir='ascending'">S</xsl:when>
                  <xsl:otherwise>false</xsl:otherwise>
                </xsl:choose>
              </xsl:param>
              <xsl:param name="userSort">
                <xsl:choose>
                  <xsl:when test="$sortAttr='@username' and $sortDir='descending'">SD</xsl:when>
                  <xsl:when test="$sortAttr='@username' and $sortDir='ascending'">S</xsl:when>
                  <xsl:otherwise>false</xsl:otherwise>
                </xsl:choose>
              </xsl:param>
              <xsl:param name="displaySort">
                <xsl:choose>
                  <xsl:when test="$sortAttr='@displayname' and $sortDir='descending'">SD</xsl:when>
                  <xsl:when test="$sortAttr='@displayname' and $sortDir='ascending'">S</xsl:when>
                  <xsl:otherwise>false</xsl:otherwise>
                </xsl:choose>
              </xsl:param>
              <xsl:param name="countSort">
                <xsl:choose>
                  <xsl:when test="$sortAttr='@count' and $sortDir='descending'">SD</xsl:when>
                  <xsl:when test="$sortAttr='@count' and $sortDir='ascending'">S</xsl:when>
                  <xsl:otherwise>false</xsl:otherwise>
                </xsl:choose>
              </xsl:param>
              initTableWidget('myTable',580,345,Array(false,'<xsl:value-of select="$hostSort"/>','<xsl:value-of select="$userSort"/>','<xsl:value-of select="$displaySort"/>','<xsl:value-of select="$countSort"/>'));
            </xsl:when>
            <xsl:when test="$details='HOST'">
            </xsl:when>
          </xsl:choose>
        </script>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>


