<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin" xmlns:exsl="http://exslt.org/common" extension-element-prefixes="exsl">
  <xsl:output method="html" version="4.01" encoding="UTF-8"/>
  
  <xsl:variable name="username"><xsl:value-of select="//fnplm:input/@username"/></xsl:variable>
  <xsl:variable name="password"><xsl:value-of select="//fnplm:input/@password"/></xsl:variable>
  <xsl:variable name="checksum"><xsl:value-of select="//fnplm:input/@checksum"/></xsl:variable>
  <xsl:variable name="cancel"><xsl:value-of select="//fnplm:input/@Cancel"/></xsl:variable>
  <xsl:variable name="compliance508"><xsl:value-of select="//fnplm:input/@compliance508"/></xsl:variable>
  <xsl:variable name="admin"><xsl:value-of select="//fnplm:input/@admin"/></xsl:variable>
  <xsl:variable name="vendor"><xsl:value-of select="//fnplm:input/@vendor" disable-output-escaping="yes" /></xsl:variable>
  <xsl:variable name="licenseTab"><xsl:value-of select="//fnplm:input/@licenseTab" disable-output-escaping="yes" /></xsl:variable>
  <xsl:variable name="selected"><xsl:value-of select="//fnplm:input/@selected" disable-output-escaping="yes" /></xsl:variable>
  <xsl:variable name="location">
    <xsl:choose>
      <xsl:when test="//fnplm:input/@location!=''">
        <xsl:value-of select="//fnplm:input/@location"/>
      </xsl:when>
      <xsl:when test="$admin='true'">systeminfo</xsl:when>
      <xsl:otherwise>dashboard</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="statusOut">
    <xsl:if test="$cancel=''">
      <xsl:value-of select="extensions:authenticate($username, $password, $checksum)" disable-output-escaping="yes"/>
    </xsl:if>
  </xsl:variable>
   <xsl:variable name="remember"><xsl:value-of select="//fnplm:input/@remember"/></xsl:variable>
   <xsl:variable name="userlocale"><xsl:value-of select="//fnplm:input/@userlocale"/></xsl:variable>
  <xsl:variable name="test"><xsl:value-of select="//fnplm:input/@test"/></xsl:variable>
  <xsl:variable name="failureLocation">
    <xsl:choose>
      <xsl:when test="$admin='true'">systeminfo</xsl:when>
      <xsl:otherwise>login</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="isAdmin">
    <xsl:value-of select="extensions:hasPrivilege('admin')" disable-output-escaping="yes" />
  </xsl:variable>
  
  <xsl:template match="/">
    <html>
      <head>
        <script type="text/javascript" src="resources/standard.js"/>
        <xsl:choose>
          <xsl:when test="$statusOut != '' and ($admin!='true' or $isAdmin='')">
            <xsl:variable name="expiredPassword">
              <xsl:value-of select="extensions:getUserList('xslt/expiredPassword.xsl')" disable-output-escaping="yes" />
            </xsl:variable>

            <xsl:value-of select="extensions:setLocale($userlocale)" disable-output-escaping="yes"/>
            <script language="javascript">
              <xsl:if test="$remember='TRUE'">
                createCookie('userName', '<xsl:value-of select="$username"/>', 365);
                createCookie('userLocale','<xsl:value-of select="$userlocale"/>', 365);
              </xsl:if>
              
              <xsl:if test="$compliance508 != 'TRUE'">
                document.location.href = "/<xsl:value-of select="$location"/>?vendor=<xsl:value-of select="$vendor"/>&amp;licenseTab=<xsl:value-of select="$licenseTab"/>&amp;selected=<xsl:value-of select="$selected"/><xsl:if test="$expiredPassword='true'">&amp;expiredPassword=true</xsl:if><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>";
              </xsl:if>
            </script>
            
            <xsl:choose>
              <xsl:when test="$expiredPassword = 'true'">
                <xsl:variable name="args">
                  <xml>
                    <fnplm:args>
                      <xsl:attribute name="href">/password?vendor=<xsl:value-of select="$vendor"/>&amp;licenseTab=<xsl:value-of select="$licenseTab"/>&amp;selected=<xsl:value-of select="$selected"/>&amp;location=<xsl:value-of select="$location"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE<xsl:if test="$expiredPassword = 'true'">&amp;expiredPassword=true</xsl:if></xsl:if></xsl:attribute>
                    </fnplm:args>
                  </xml>
                </xsl:variable>
                <xsl:value-of select="extensions:getFormattedString('IDS_PASSWORD_REDIRECT_MESSAGE', exsl:node-set($args)/xml/*)" disable-output-escaping="yes"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:variable name="args">
                  <xml>
                    <fnplm:args>
                      <xsl:attribute name="href">/<xsl:value-of select="$location"/>?vendor=<xsl:value-of select="$vendor"/>&amp;licenseTab=<xsl:value-of select="$licenseTab"/>&amp;selected=<xsl:value-of select="$selected"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE<xsl:if test="$expiredPassword = 'true'">&amp;expiredPassword=true</xsl:if></xsl:if></xsl:attribute>
                    </fnplm:args>
                  </xml>
                </xsl:variable>
                <xsl:value-of select="extensions:getFormattedString('IDS_REDIRECT_MESSAGE', exsl:node-set($args)/xml/*)" disable-output-escaping="yes"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
            <xsl:variable name="failureReason">
              <xsl:choose>
                <xsl:when test="$statusOut!='' and $isAdmin!=''">permission</xsl:when>
                <xsl:otherwise>authenticate</xsl:otherwise>
              </xsl:choose>
            </xsl:variable>
            <script language="javascript">
              <xsl:if test="$remember='TRUE'">
                createCookie('userName', '<xsl:value-of select="$username"/>', 365);
              </xsl:if>
              <xsl:choose>
                <xsl:when test="$test!='true'">
                  <xsl:choose>
                    <xsl:when test="$cancel!=''">
                      <xsl:choose>
                        <xsl:when test="$compliance508!='TRUE'">
                          document.location.href = "/login";
                        </xsl:when>
                        <xsl:otherwise>
                          document.location.href = "/login508";
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:when>
                    <xsl:when test="$compliance508!='TRUE'">
                      document.location.href = "/<xsl:value-of select="$failureLocation"/>?vendor=<xsl:value-of select="$vendor"/>&amp;licenseTab=<xsl:value-of select="$licenseTab"/>&amp;selected=<xsl:value-of select="$selected"/>&amp;failed=<xsl:value-of select="$failureReason"/>";
                    </xsl:when>
                    <xsl:otherwise>
                      document.location.href = "/login508?vendor=<xsl:value-of select="$vendor"/>&amp;licenseTab=<xsl:value-of select="$licenseTab"/>&amp;selected=<xsl:value-of select="$selected"/>&amp;failed=<xsl:value-of select="$failureReason"/>";
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                  document.location.href = "/signin?vendor=<xsl:value-of select="$vendor"/>&amp;licenseTab=<xsl:value-of select="$licenseTab"/>&amp;selected=<xsl:value-of select="$selected"/>&amp;test=true&amp;failed=<xsl:value-of select="$failureReason"/>";
                </xsl:otherwise>
              </xsl:choose>
            </script>
            
            <xsl:variable name="args">
              <xml>
                <fnplm:args>
                  <xsl:attribute name="href">
                    <xsl:choose>
                      <xsl:when test="$compliance508!='TRUE'">/<xsl:value-of select="$failureLocation"/>?vendor=<xsl:value-of select="$vendor"/>&amp;licenseTab=<xsl:value-of select="$licenseTab"/>&amp;selected=<xsl:value-of select="$selected"/>&amp;failed=<xsl:value-of select="$failureReason"/></xsl:when>
                      <xsl:otherwise>/login508?vendor=<xsl:value-of select="$vendor"/>&amp;licenseTab=<xsl:value-of select="$licenseTab"/>&amp;selected=<xsl:value-of select="$selected"/>&amp;location=<xsl:value-of select="$location"/>&amp;admin=<xsl:value-of select="$admin"/>&amp;failed=<xsl:value-of select="$failureReason"/>&amp;compliance508=TRUE</xsl:otherwise>
                    </xsl:choose>
                  </xsl:attribute>
                </fnplm:args>
              </xml>
            </xsl:variable>
              
            <xsl:value-of select="extensions:getFormattedString('IDS_AUTHENTICATE_FAILED_MESSAGE', exsl:node-set($args)/xml/*)" disable-output-escaping="yes"/>
          </xsl:otherwise>
        </xsl:choose>
      </head>
    </html>
  </xsl:template>
</xsl:stylesheet>

