<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin" xmlns:exsl="http://exslt.org/common" extension-element-prefixes="exsl">
  <xsl:template match="/" name="password">
    <html>
      <head>
        <xsl:choose>
          <xsl:when test="$compliance508!='TRUE'">
            <link rel="stylesheet" type="text/css" href="resources/content.css"/>
            <link rel="stylesheet" type="text/css" href="resources/structure.css"/>
            <link rel="stylesheet" type="text/css" href="resources/veneer.css"/>
            <link rel="stylesheet" type="text/css" href="resources/veneerPopup.css"/>
          </xsl:when>
          <xsl:otherwise>
            <link rel="stylesheet" type="text/css" href="resources/508/content.css"/>
            <link rel="stylesheet" type="text/css" href="resources/508/structure.css"/>
            <link rel="stylesheet" type="text/css" href="resources/508/veneer.css"/>
            <link rel="stylesheet" type="text/css" href="resources/508/veneerPopup.css"/>
          </xsl:otherwise>
        </xsl:choose>
        <script type="text/javascript" src="resources/ajax.js"/>
        <script type="text/javascript" src="resources/popup.js"/>
        <script type="text/javascript" src="resources/drag.js"/>
        <script type="text/javascript" src="resources/standard.js"/>
      
        <meta http-equiv="Cache-Control" content="no-cache"/>
        <meta http-equiv="Pragma" content="no-cache"/>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        
        <script language="javascript">
          function checkPassword() {
            var passw_pattern =  /(?=.*).{8,}/;
            var user = '<xsl:value-of select="extensions:getCurrentUser('xslt/userName.xsl')" disable-output-escaping="yes" />' ;
            if (document.passwordform.elements["oldpassword"].value == "") {
              alert("<xsl:value-of select="extensions:getString('IDS_OLD_PASSWORD_BLANK_ERROR')" disable-output-escaping="yes"/>");
            } else if (document.passwordform.elements["newpassword"].value == "") {
              alert("<xsl:value-of select="extensions:getString('IDS_PASSWORD_BLANK_ERROR')" disable-output-escaping="yes"/>");
            } else if (document.passwordform.elements["newpassword"].value !=
                document.passwordform.elements["confirmpassword"].value) {
              alert("<xsl:value-of select="extensions:getString('IDS_PASSWORD_MISMATCH_ERROR')" disable-output-escaping="yes"/>");
            } else if (!passw_pattern.test(document.passwordform.elements["newpassword"].value)) {
              alert("<xsl:value-of select="extensions:getString('IDS_NEW_PASSWORD_PATTERN_MISMATCH_ERROR')" disable-output-escaping="yes"/>");
            } else if (document.passwordform.elements["newpassword"].value.toUpperCase() == user.toUpperCase()) {
              alert("<xsl:value-of select="extensions:getString('IDS_PASSWORD_SAME_AS_USER_ERROR')" disable-output-escaping="yes"/>");
            } else if (document.passwordform.elements["oldpassword"].value ==
                document.passwordform.elements["newpassword"].value) {
              alert("<xsl:value-of select="extensions:getString('IDS_NEW_PASSWORD_SAME_AS_OLD_ERROR')" disable-output-escaping="yes"/>");
            } else {
              return true;
            }
            
            return false;
          }
        </script>
      </head>

      <body SCROLL="YES">
        <form action="/handlepassword" method="post" name="passwordform">
          <xsl:if test="$compliance508='TRUE'">
            <input type="hidden" name="compliance508" value="TRUE"/>
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="location" value="<xsl:value-of select="$location"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
          </xsl:if>
          <xsl:if test="$expiredPassword = 'true'">
            <xsl:if test="$save = '' or $changePasswordReturn != ''">
              <input type="hidden" name="expiredPassword" value="true"/>
            </xsl:if>
          </xsl:if>
          <xsl:text disable-output-escaping="yes">&lt;</xsl:text>table <xsl:if test="$compliance508!='TRUE'">width="320"</xsl:if><xsl:text disable-output-escaping="yes">&gt;</xsl:text><tr><td>
            <div class="contentSpacer">
              <xsl:if test="$cancel=''">
                <h1><xsl:value-of select="extensions:getString('IDS_CHANGE_PASSWORD_HEADER')" disable-output-escaping="yes"/></h1>
              </xsl:if>
              <p>
                <xsl:if test="$expiredPassword = 'true'">
                  <xsl:if test="$save = '' or $changePasswordReturn != ''">
                    <xsl:value-of select="extensions:getString('IDS_PASSWORD_EXPIRED')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/p<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&lt;</xsl:text>p<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                  </xsl:if>
                </xsl:if>
                <xsl:choose>
                  <xsl:when test="$failed!=''">
                    <font color="#cc0000"><b>
                      <xsl:choose>
                        <xsl:when test="$failed='authenticate'"><xsl:value-of select="extensions:getString('IDS_AUTHENTICATE_FAILURE')" disable-output-escaping="yes"/></xsl:when>
                        <xsl:when test="$failed='readonly'"><xsl:value-of select="extensions:getString('ERROR_CONFIG_READ_ONLY')" disable-output-escaping="yes"/></xsl:when>
                        <xsl:otherwise><xsl:value-of select="extensions:getString('IDS_PASSWORD_CHANGE_FAILURE')" disable-output-escaping="yes"/></xsl:otherwise>
                      </xsl:choose>
                    </b></font><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/p<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&lt;</xsl:text>p<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                  </xsl:when>
                  <xsl:when test="$cancel!=''">
                    <script language="javascript">
                      document.location.href = "/<xsl:value-of select="$location"/>?success=true<xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>";
                    </script>
                    
                    <xsl:variable name="args">
                      <xml>
                        <fnplm:args>
                          <xsl:attribute name="href">/<xsl:value-of select="$location"/><xsl:if test="$compliance508='TRUE'">?compliance508=TRUE</xsl:if></xsl:attribute>
                        </fnplm:args>
                      </xml>
                    </xsl:variable>
                    <xsl:value-of select="extensions:getFormattedString('IDS_CANCEL_PASSWORD_MESSAGE', exsl:node-set($args)/xml/*)" disable-output-escaping="yes"/>
                  </xsl:when>
                  <xsl:when test="$success!=''">
                    <font color="#6CBE06"><b>
                      <xsl:value-of select="extensions:getString('IDS_PASSWORD_CHANGE_SUCCESS')" disable-output-escaping="yes"/>
                    </b></font><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/p<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&lt;</xsl:text>p<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                  </xsl:when>
                  <xsl:when test="$noMatch='TRUE'">
                    <font color="#cc0000"><b><xsl:value-of select="extensions:getString('IDS_PASSWORD_MISMATCH_ERROR')" disable-output-escaping="yes"/></b></font><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/p<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&lt;</xsl:text>p<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                  </xsl:when>
                  <xsl:when test="$noPassword='TRUE'">
                    <font color="#cc0000"><b><xsl:value-of select="extensions:getString('IDS_PASSWORD_BLANK_ERROR')" disable-output-escaping="yes"/></b></font><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/p<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&lt;</xsl:text>p<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                  </xsl:when>
                  <xsl:when test="substring-after($changePasswordReturn, 'ERROR_CONFIG_READ_ONLY:')!=''">
                    <font color="#cc0000"><b><xsl:value-of select="extensions:getString('ERROR_CONFIG_READ_ONLY')" disable-output-escaping="yes"/></b></font><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/p<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&lt;</xsl:text>p<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                  </xsl:when>
                  <xsl:when test="$changePasswordReturn!=''">
                    <font color="#cc0000"><b><xsl:value-of select="extensions:getString('IDS_AUTHENTICATE_FAILURE')" disable-output-escaping="yes"/></b></font><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/p<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&lt;</xsl:text>p<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                  </xsl:when>
                </xsl:choose>
              </p>
              <xsl:if test="$cancel='' and $success=''">
                <xsl:value-of select="extensions:getString('IDS_USER_NAME_LABEL')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="extensions:getCurrentUser('xslt/userName.xsl')" disable-output-escaping="yes" />
                <p></p>
                <xsl:value-of select="extensions:getString('IDS_OLD_PASSWORD_LABEL')" disable-output-escaping="yes"/><br/>
                <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="password" size="25" alt="<xsl:value-of select="extensions:getString('IDS_ALT_OLD_PASSWORD')" disable-output-escaping="yes"/>" name="oldpassword"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                <p></p>
                <xsl:value-of select="extensions:getString('IDS_NEW_PASSWORD_LABEL')" disable-output-escaping="yes"/><br/>
                <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="password" size="25" name="newpassword" alt="<xsl:value-of select="extensions:getString('IDS_ALT_NEW_PASSWORD')" disable-output-escaping="yes"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text><br/>
                <p></p>
                <xsl:value-of select="extensions:getString('IDS_CONFIRM_PASSWORD_LABEL')" disable-output-escaping="yes"/><br/>
                <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="password" size="25" name="confirmpassword" alt="<xsl:value-of select="extensions:getString('IDS_ALT_CONFIRM_PASSWORD')" disable-output-escaping="yes"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text><br/>
                <p></p>
                <xsl:choose>
                  <xsl:when test="compliance508!='TRUE'">
                    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>div align="right"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>div align="left"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                  </xsl:otherwise>
                </xsl:choose>
                  <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="submit" name="Save" value="<xsl:value-of select="extensions:getString('IDS_SAVE_LABEL')" disable-output-escaping="yes"/>" class="button" onmouseover="this.className='button buttonHover'" onmouseout="this.className='button'" onClick="return checkPassword();" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                  <xsl:if test="$expiredPassword != 'true'">
                    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="submit" name="Cancel" value="<xsl:value-of select="extensions:getString('IDS_CANCEL_LABEL')" disable-output-escaping="yes"/>" class="button" onmouseover="this.className='button buttonHover'" onmouseout="this.className='button'" onClick="parent.GB_hidePassword(); return false;" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                  </xsl:if>
                <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/div<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
              </xsl:if>
              <xsl:if test="$success!=''">
              <br />
                <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="submit" name="Cancel" value="<xsl:value-of select="extensions:getString('IDS_OK_LABEL')" disable-output-escaping="yes"/>" class="button" onmouseover="this.className='button buttonHover'" onmouseout="this.className='button'" onClick="parent.GB_hidePassword(); return false;" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
              </xsl:if>
              </div>
          </td></tr><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/table<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        </form>
        <script type="text/javascript">
          document.passwordform.oldpassword.focus();
        </script>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>

