<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:param name="selectedEnv"><xsl:value-of select="extensions:getEnv('selected')" disable-output-escaping="yes"/></xsl:param>
  <xsl:param name="vendorEnvTemp"><xsl:value-of select="extensions:getEnv('vendor')" disable-output-escaping="yes"/></xsl:param>
  <xsl:param name="vendorEnv"><xsl:value-of select="extensions:getVendorList($vendorEnvTemp, 'xslt/testVendorParameter.xsl')" disable-output-escaping="yes" /></xsl:param>
  <xsl:param name="licenseTabEnv"><xsl:value-of select="extensions:getEnv('licenseTab')" disable-output-escaping="yes"/></xsl:param>
  <xsl:param name="adminTabEnv"><xsl:value-of select="extensions:getEnv('admin')" disable-output-escaping="yes"/></xsl:param>
  <xsl:variable name="adminTab">
    <xsl:choose>
      <xsl:when test="$adminTabEnv!=''"><xsl:value-of select="$adminTabEnv"/></xsl:when>
      <xsl:when test="$admin='USERS'">users</xsl:when>
      <xsl:when test="$admin='ALERTS'">alerts</xsl:when>
      <xsl:when test="$admin='VENDOR'">vendor</xsl:when>
      <xsl:when test="$admin='CONFIG'">admin</xsl:when>
      <xsl:otherwise>systeminfo</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:template match="/" name="headerNav">
    <div id="header">
      <div id="logoBackground">
        <div id="logo"></div>
        <xsl:if test="$protectDashboard='true' or $isAdmin=''">
          <xsl:variable name="userName">
            <xsl:value-of select="extensions:getCurrentUser('xslt/userName.xsl')" disable-output-escaping="yes" />
          </xsl:variable>
          <div id="userDisplay"><xsl:value-of select="extensions:getString('IDS_USER_NAME')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
            <xsl:choose>
              <xsl:when test="substring-after($userName, ':')!=''">
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="$userName" disable-output-escaping="yes" />
              </xsl:otherwise>
            </xsl:choose>
          </div>
        </xsl:if>
        <div id="navHelp">
          <xsl:choose>
            <xsl:when test="$compliance508!='TRUE'">
              <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="#" onclick="javascript:NewWindow('<xsl:value-of select="extensions:getString($help_id)" disable-output-escaping="yes"/>', 'FlexNet', '650','600','yes','yes');" onmouseover="rollover('help','images/icons/32helpOver.gif');" onmouseout="rollover('help','images/icons/32help.gif');" accesskey="3"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><img src="images/icons/32help.gif" border="0" name="help" /><br /><xsl:value-of select="extensions:getString('IDS_HELP_LABEL')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="<xsl:value-of select="extensions:getString($help_id)" disable-output-escaping="yes"/>" target="_blank" accesskey="3"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><img src="images/icons/32help.gif" border="0" name="help" /><br /><xsl:value-of select="extensions:getString('IDS_HELP_LABEL')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
            </xsl:otherwise>
            </xsl:choose>
        </div>
        <div id="navSignout"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="signout<xsl:if test="$compliance508='TRUE'">?compliance508=TRUE</xsl:if>" onmouseover="rollover('signout','images/icons/32logoutOver.gif');" onmouseout="rollover('signout','images/icons/32logout.gif');" accesskey="9"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><img src="images/icons/32logout.gif" border="0" name="signout" /><br /><xsl:value-of select="extensions:getString('IDS_SIGN_OUT_LABEL')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text></div>
        <div id="mainLink"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
       
        <xsl:choose>
          <xsl:when test="$dashboard='TRUE'">
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>div id="mainLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>div id="mainLinkSelected"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
          <xsl:when test="$isAdmin='' or $protectDashboard='false'">
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="<xsl:value-of select="$adminTab"/>?vendor=<xsl:value-of select="$vendorEnv"/>&amp;licenseTab=<xsl:value-of select="$licenseTabEnv"/>&amp;selected=<xsl:value-of select="$selectedEnv"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>" accesskey="2"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_ADMIN_LABEL')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
          </xsl:when>
          <xsl:otherwise><span class="text"><xsl:value-of select="extensions:getString('IDS_ADMIN_LABEL')" disable-output-escaping="yes"/></span></xsl:otherwise>
        </xsl:choose>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/div<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        <xsl:choose>
          <xsl:when test="$dashboard='TRUE'">
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>div id="mainLinkSelected"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>div id="mainLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="dashboard?vendor=<xsl:value-of select="$vendorEnv"/>&amp;licenseTab=<xsl:value-of select="$licenseTabEnv"/>&amp;admin=<xsl:value-of select="$adminTab"/>&amp;selected=<xsl:value-of select="$selectedEnv"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>" accesskey="1"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_DASHBOARD_LABEL')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/div<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      </div>
      <div id="subheader1"></div>
    </div>
  </xsl:template>
</xsl:stylesheet>
