<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">

  <xsl:template name="adminAlerts">
    <h1><xsl:value-of select="extensions:getString('IDS_ALERTS_HEADER')" disable-output-escaping="yes"/></h1>
    <xsl:choose>
      <xsl:when test="$message='SAVE_OK'">
        <font color="#6CBE06"><b>
          <xsl:value-of select="extensions:getString('IDS_ALERT_SAVE_SUCCESSFUL')" disable-output-escaping="yes"/>
        </b></font>
      </xsl:when>
      <xsl:when test="$message='NO_MESSAGE'"></xsl:when>
      <xsl:when test="$message!=''">
        <font color="#CC0000"><b>
          <xsl:copy-of select="$message" />
        </b></font>
      </xsl:when>
    </xsl:choose>
    <div class="Container860">
      <div class="Column20Percent"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
      <div class="Column20Percent"><h2><xsl:value-of select="extensions:getString('IDS_SEND_ALERTS_TO_HEADER')" disable-output-escaping="yes"/></h2></div>
      <div class="Column59Percent"><h2><xsl:value-of select="extensions:getString('')" disable-output-escaping="yes"/></h2></div>
    </div>	
    <div class="Container860">
      <xsl:variable name="alertsConfigReturn">
        <xsl:value-of select="extensions:getAlertsConfig('xslt/adminAlertsForm.xsl')" disable-output-escaping="yes" />
      </xsl:variable>
      
      <xsl:choose>
        <xsl:when test="starts-with($alertsConfigReturn, 'ERROR_EXPIRED_SESSION:')">
          <xsl:call-template name="sessionTimeout"/>
        </xsl:when>
        <xsl:when test="$alertsConfigReturn!=''">
          <xsl:copy-of select="$alertsConfigReturn"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:copy-of select="$alertsConfigReturn"/>
        </xsl:otherwise>
      </xsl:choose>
    </div>
  </xsl:template>
</xsl:stylesheet>

