<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">

  <xsl:template name="adminVendor">
    <xsl:if test="$vendorEvent!='edit' and $vendorEvent!='create' and substring-after($eventResult, 'MULTIPLE_RESULTS:')='' and $saveConfig='' and $vendorEvent!='save' and $rotate='' and $vendorEvent!='rotatelog'">
      <h1><xsl:value-of select="extensions:getString('IDS_VENDOR_DAEMON_HEADER')" disable-output-escaping="yes"/></h1>
      <xsl:choose>
        <xsl:when test="$vendorEvent='importLicense'">
          <xsl:choose>
            <xsl:when test="substring-after($eventResult, ':')!=''">
              <font color="#CC0000"><b>
                <xsl:value-of select="$message" disable-output-escaping="yes"/>
                </b></font>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="$message" disable-output-escaping="yes" />
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:when test="$message='VENDOR_SAVE_SUCCESSFUL' or $message='VENDOR_SAVE_AND_REREAD_SUCCESSFUL' or $message='ROTATE_LOG_SUCCESSFUL' or $message='REREAD_SUCCESSFUL'">
          <xsl:variable name="tempString">IDS_<xsl:value-of select="$message"/></xsl:variable>
          <font color="#6CBE06"><b>
            <xsl:value-of select="extensions:getString($tempString)" disable-output-escaping="yes"/>
          </b></font>
          <xsl:if test="$license!=$oldLicense">
            <br/><xsl:value-of select="extensions:getString('IDS_LICENSE_FILE_CHANGED')" disable-output-escaping="yes"/>
          </xsl:if>
        </xsl:when>
        <xsl:when test="$message='START_DAEMON_SUCCESSFUL' or $message='STOP_DAEMON_SUCCESSFUL' or $message='DELETE_DAEMON_SUCCESSFUL'">
          <xsl:variable name="tempString">IDS_<xsl:value-of select="$message"/></xsl:variable>
          <font color="#6CBE06"><b>
            <xsl:value-of select="extensions:getString($tempString)" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="$vendor"/>
          </b></font>
        </xsl:when>
        <xsl:when test="$message='NO_MESSAGE'">
        </xsl:when>
        <xsl:when test="$message!=''">
          <font color="#CC0000"><b>
            <xsl:copy-of select="$message" />
          </b></font>
        </xsl:when>
      </xsl:choose>
      
      <xsl:if test="$vendorEvent!='create'">
        <div class="giveBorder">
          <div class="columnBlockClick">
            <div class="columnBlockButton" >
              <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a onmouseover="rollover('addUser','images/icons/addLicenseOver.png');" onmouseout="rollover('addUser','images/icons/addLicenseOut.png');" href="/vendor?event=create&amp;licenseTab=<xsl:value-of select="$licenseTab"/>&amp;selected=<xsl:value-of select="$selected"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                <img src="images/icons/addLicenseOut.png" name="addUser" />
              <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
              <br />
              <div class="largerText"><strong><xsl:value-of select="extensions:getString('IDS_IMPORT_LICENSE_FILE_LABEL')" disable-output-escaping="yes"/></strong></div>
            </div>
          </div>
        </div>
        <br/>
      
        <div class="widgetTableDiv">
          <!--LT/>table id="myTable" cellspacing="0" summary="<xsl:value-of select="extensions:getString('IDS_VENDOR_TABLE_DESCRIPTION')" disable-output-escaping="yes"/>" width="100%"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><NBSP/-->
          <script language="javascript">
             function submitVendorListForm(vendorName, event) {
             document.vendorlistform.elements["vendor"].value = vendorName;
             document.vendorlistform.elements["event"].value = event;
             if (event=='delete') {
               if (!confirm("<xsl:value-of select="extensions:getString('IDS_CONFIRM_VENDOR_DELETE')" disable-output-escaping="yes"/>")) {
                 return;
               }
             }
       
             document.vendorlistform.submit();
            }
          </script>
          <form action="/vendor" method="post" name="vendorlistform">
          <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="checksum" value="<xsl:value-of select="extensions:setChecksum('vendorlistform')"/>" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
           <input type="hidden" name="vendor"/>
           <input type="hidden" name="event"/>
           <xsl:if test="$compliance508='TRUE'">
              <input type="hidden" name="compliance508" value="TRUE"/>
           </xsl:if>
           <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="licenseTab" value="<xsl:value-of select="$licenseTab"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
           <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="selected" value="<xsl:value-of select="$selected"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>

           <table id="myTable">
            <thead>
              <tr>
                <td style="visibility:hidden"></td>
                <td width="23%"><xsl:value-of select="extensions:getString('IDS_VENDOR_NAME_HEADER')" disable-output-escaping="yes"/></td>
                <td width="17%" id="header2"><xsl:value-of select="extensions:getString('IDS_STATUS_HEADER')" disable-output-escaping="yes"/></td>
                <td width="22%" id="header3"><div align="center"><xsl:value-of select="extensions:getString('IDS_LICENSING_VERSION_HEADER')" disable-output-escaping="yes"/></div></td>
                <td width="14%" id="header4"><div align="center"><xsl:value-of select="extensions:getString('IDS_ACTUAL_PORT_HEADER')" disable-output-escaping="yes"/></div></td>
                <td width="12%" id="header5"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></td>
                <td width="12%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></td>
              </tr>
            </thead>
          
            <tbody class="scrollingContent">
              <xsl:variable name="vendorStatusReturn">
                <xsl:value-of select="extensions:getVendorList($vendor, 'xslt/vendorsList.xsl')" disable-output-escaping="yes" />
              </xsl:variable>
        
              <xsl:choose>
                <xsl:when test="$login='TRUE'"></xsl:when>
                <xsl:when test="starts-with($vendorStatusReturn, 'ERROR_EXPIRED_SESSION:')">
                  <xsl:call-template name="sessionTimeout"/>
                </xsl:when>
                <xsl:when test="$vendorStatusReturn != ''">
                  <xsl:copy-of select="$vendorStatusReturn"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:copy-of select="$vendorStatusReturn"/>
                </xsl:otherwise>
              </xsl:choose>
            </tbody>
           <!--LT/>/table<xsl:text disable-output-escaping="yes">&gt;</xsl:text><NBSP/-->
           </table>
         </form>
        </div>
      </xsl:if>
    </xsl:if>
    
    <xsl:if test="$vendorEvent!='edit' and substring-after($eventResult, 'MULTIPLE_RESULTS:')!=''">
      <xsl:value-of select="substring-after($eventResult, 'MULTIPLE_RESULTS:')" disable-output-escaping="yes"/>
      <form action="/vendor" method="post">
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="licenseTab" value="<xsl:value-of select="$licenseTab"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="selected" value="<xsl:value-of select="$selected"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        <xsl:if test="$compliance508='TRUE'">
          <input type="hidden" name="compliance508" value="TRUE"/>
        </xsl:if>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="vendor" value="<xsl:value-of select="./@name"/>" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="submit" name="OK" value="<xsl:value-of select="extensions:getString('IDS_OK_LABEL')" disable-output-escaping="yes"/>" class="button" onmouseover="this.className='button buttonHover'" onmouseout="this.className='button'" style="width: 80px;"" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      </form>
    </xsl:if>
    
    <xsl:if test="$event='edit' or $saveConfig!='' or $vendorEvent='save' or $rotate!='' or $vendorEvent='rotatelog'">
      <br/>
      <h1><xsl:value-of select="extensions:getString('IDS_VENDOR_DAEMON_LABEL')" disable-output-escaping="yes"/><xsl:value-of select="$vendor"/></h1>
      <xsl:choose>
        <xsl:when test="$vendorEvent='importLicense'">
          <xsl:choose>
            <xsl:when test="substring-after($eventResult, ':')!=''">
              <font color="#CC0000">
                <b>
                  <xsl:value-of select="$message" disable-output-escaping="yes"/>
                </b>
              </font>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="$message" disable-output-escaping="yes" />
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:when test="$message='VENDOR_SAVE_SUCCESSFUL' or $message='VENDOR_SAVE_AND_REREAD_SUCCESSFUL' or $message='ROTATE_LOG_SUCCESSFUL' or $message='REREAD_SUCCESSFUL'">
          <xsl:variable name="tempString">IDS_<xsl:value-of select="$message"/></xsl:variable>
          <font color="#6CBE06">
            <b>
              <xsl:value-of select="extensions:getString($tempString)" disable-output-escaping="yes"/>
            </b>
          </font>
          <xsl:if test="$license!=$oldLicense">
            <br/>
            <xsl:value-of select="extensions:getString('IDS_LICENSE_FILE_CHANGED')" disable-output-escaping="yes"/>
          </xsl:if>
        </xsl:when>
        <xsl:when test="$message='START_DAEMON_SUCCESSFUL' or $message='STOP_DAEMON_SUCCESSFUL' or $message='DELETE_DAEMON_SUCCESSFUL'">
          <xsl:variable name="tempString">IDS_<xsl:value-of select="$message"/></xsl:variable>
          <font color="#6CBE06">
            <b>
              <xsl:value-of select="extensions:getString($tempString)" disable-output-escaping="yes"/>
              <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
              <xsl:value-of select="$vendor"/>
            </b>
          </font>
        </xsl:when>
        <xsl:when test="$message='NO_MESSAGE'">
        </xsl:when>
        <xsl:when test="$message!=''">
          <font color="#CC0000">
            <b>
              <xsl:copy-of select="$message" />
            </b>
          </font>
        </xsl:when>
      </xsl:choose>
      <p></p>
    
      <xsl:variable name="vendorStatusReturn">
        <xsl:value-of select="extensions:getVendorList($vendor, 'xslt/adminVendorForm.xsl')" disable-output-escaping="yes" />
      </xsl:variable>
      <xsl:choose>
        <xsl:when test="starts-with($vendorStatusReturn, 'ERROR_EXPIRED_SESSION:')">
          <xsl:call-template name="sessionTimeout"/>
        </xsl:when>
        <xsl:when test="$vendorStatusReturn != ''">
          <xsl:copy-of select="$vendorStatusReturn"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:copy-of select="$vendorStatusReturn"/>
        </xsl:otherwise>
      </xsl:choose>
      <p></p>

      <script type="text/javascript">
        Element.cleanWhitespace('accordionContent');
        init();
      </script>
    </xsl:if>
      
    <xsl:if test="$event='create'">    
      <script language="javascript">
        function submitImportForm(eventParam) {
          document.importForm.elements["event"].value = eventParam;
          if (eventParam == 'cancel') {
            document.importForm.reset();
          }
          else if (document.importForm.licenseFile.value.trim() == "") {
            alert("<xsl:value-of select="extensions:getString('IDS_LICENSE_FILE_REQUIRED')" disable-output-escaping="yes"/>"); 
            return false;
          }
          
          return true;
        }
      </script>

      <h1><xsl:value-of select="extensions:getString('IDS_IMPORT_LICENSE_HEADER')" disable-output-escaping="yes"/></h1>
      
      <form action="/vendor" method="post" enctype="multipart/form-data" name="importForm">
        <xsl:if test="$compliance508='TRUE'">
          <input type="hidden" name="compliance508" value="TRUE"/>
        </xsl:if>
		<xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="checksum" value="<xsl:value-of select="extensions:setChecksum('importForm')"/>" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="licenseTab" value="<xsl:value-of select="$licenseTab"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="selected" value="<xsl:value-of select="$selected"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        <input type="hidden" name="event" value="importLicense"/><br/>
        <strong><label for="path"><xsl:value-of select="extensions:getString('IDS_LOCAL_LICENSE_FILE_LABEL')" disable-output-escaping="yes"/></label></strong><br/>
        <input type="file" name="licenseFile" size="40"/><br/>
        <input type="checkbox" name="overwrite" value="true"/><strong><xsl:value-of select="extensions:getString('IDS_OVERWRITE_LICENSE_FILE_LABEL')" disable-output-escaping="yes"/></strong><br/>
        <br/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="submit" name="ImportLicense" value="<xsl:value-of select="extensions:getString('IDS_IMPORT_LICENSE_FILE_LABEL')" disable-output-escaping="yes"/>" class="button" onmouseover="this.className='button buttonHover'" onmouseout="this.className='button'" style="width: 120px;"  onclick="return submitImportForm('importLicense');" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="submit" name="Cancel" value="<xsl:value-of select="extensions:getString('IDS_CANCEL_LABEL')" disable-output-escaping="yes"/>" class="button" onmouseover="this.className='button buttonHover'" onmouseout="this.className='button'" onclick="return submitImportForm('cancel');" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      </form>
    </xsl:if>
    
    <xsl:if test="$event!='edit'and $event!='create'">
      <script type="text/javascript">
        initTableWidget('myTable',845,430,Array(false, 'S','S1','S1',false, false), true);
      </script>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>
