<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:output method="html"/>
  <xsl:param name="compliance508"><xsl:value-of select="extensions:getEnv('compliance508')" disable-output-escaping="yes"/></xsl:param>
  <xsl:param name="licenseTab"><xsl:value-of select="extensions:getEnv('licenseTab')" disable-output-escaping="yes" /></xsl:param>
  <xsl:param name="selected"><xsl:value-of select="extensions:getEnv('selected')" disable-output-escaping="yes" /></xsl:param>
  
  <xsl:template match="/" name="users">
     <xsl:apply-templates select="xml/fnplm:vendors" />
     <xsl:apply-templates select="xml/fnplm:users" />
  </xsl:template>
  
  <xsl:template match="fnplm:users">
    <xsl:apply-templates select="fnplm:user[@id!='alerter']" />
  </xsl:template>
  
  <xsl:template match="fnplm:user[@id!='alerter']">
  	<xsl:variable name="my_user_test">
	  <xsl:value-of select="./@type" disable-output-escaping="yes" />
	</xsl:variable>
	<xsl:if test="starts-with($my_user_test, 'local')">
     <xsl:param name="admin"><xsl:apply-templates select="fnplm:privileges"/></xsl:param>
     <tr>
      <td style="visibility:hidden"></td>
      <xsl:text disable-output-escaping="yes">&lt;</xsl:text>td onClick="javascript:submitUserListForm('<xsl:value-of select="./@id"/>', '<xsl:value-of select="./@first"/>', '<xsl:value-of select="./@last"/>', '<xsl:value-of select="$admin" disable-output-escaping="no"/>', '<xsl:value-of select="./@passwordExpired"/>', 'edit', '<xsl:value-of select="./@type"/>')" <xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="./@id"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/td<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;</xsl:text>td onClick="javascript:submitUserListForm('<xsl:value-of select="./@id"/>', '<xsl:value-of select="./@first"/>', '<xsl:value-of select="./@last"/>', '<xsl:value-of select="$admin" disable-output-escaping="no"/>', '<xsl:value-of select="./@passwordExpired"/>', 'edit', '<xsl:value-of select="./@type"/>')" <xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="./@first"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/td<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;</xsl:text>td onClick="javascript:submitUserListForm('<xsl:value-of select="./@id"/>', '<xsl:value-of select="./@first"/>', '<xsl:value-of select="./@last"/>', '<xsl:value-of select="$admin" disable-output-escaping="no"/>', '<xsl:value-of select="./@passwordExpired"/>', 'edit', '<xsl:value-of select="./@type"/>')" <xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="./@last"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/td<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;</xsl:text>td onClick="javascript:submitUserListForm('<xsl:value-of select="./@id"/>', '<xsl:value-of select="./@first"/>', '<xsl:value-of select="./@last"/>', '<xsl:value-of select="$admin" disable-output-escaping="no"/>', '<xsl:value-of select="./@passwordExpired"/>', 'edit', '<xsl:value-of select="./@type"/>')" <xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        <xsl:choose>
          <xsl:when test="$admin='admin'"><xsl:value-of select="extensions:getString('IDS_ADMIN')" disable-output-escaping="yes"/></xsl:when>
          <xsl:otherwise><xsl:value-of select="extensions:getString('IDS_ADMIN_READONLY')" disable-output-escaping="yes"/></xsl:otherwise>
        </xsl:choose>
      <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/td<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      <xsl:choose>
        <xsl:when test="$compliance508!='TRUE'">
          <td><xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="javascript:submitUserListForm('<xsl:value-of select="./@id"/>', '<xsl:value-of select="./@first"/>', '<xsl:value-of select="./@last"/>', '<xsl:value-of select="$admin" disable-output-escaping="no"/>', '<xsl:value-of select="./@passwordExpired"/>', 'edit', '<xsl:value-of select="./@type"/>')" class="textLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_EDIT_LINK')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text></td>
          <td><xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="javascript:submitUserListForm('<xsl:value-of select="./@id"/>', '<xsl:value-of select="./@first"/>', '<xsl:value-of select="./@last"/>', '<xsl:value-of select="$admin" disable-output-escaping="no"/>', '<xsl:value-of select="./@passwordExpired"/>', 'delete', '<xsl:value-of select="./@type"/>')" class="textLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_DELETE_LINK')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text></td>
        </xsl:when>
        <xsl:otherwise>
          <td><xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="/users?userName=<xsl:value-of select="./@id"/>&amp;firstName=<xsl:value-of select="./@first"/>&amp;lastName=<xsl:value-of select="./@last"/>&amp;accountType=<xsl:value-of select="$admin" disable-output-escaping="no"/>&amp;passwordExpired=<xsl:value-of select="./@passwordExpired"/>&amp;event=edit&amp;userType=<xsl:value-of select="./@type"/>&amp;compliance508=TRUE" class="textLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_EDIT_LINK')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text></td>
          <td><xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="/users?userName=<xsl:value-of select="./@id"/>&amp;firstName<xsl:value-of select="./@first"/>&amp;lastName<xsl:value-of select="./@last"/>&amp;accountType=<xsl:value-of select="$admin" disable-output-escaping="no"/>&amp;passwordExpired=<xsl:value-of select="./@passwordExpired"/>&amp;event=delete&amp;userType=<xsl:value-of select="./@type"/>&amp;compliance508=TRUE" class="textLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_DELETE_LINK')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text></td>
        </xsl:otherwise>
      </xsl:choose>
    </tr>
	</xsl:if>
  </xsl:template>
  
  <xsl:template match="fnplm:privileges">
    <xsl:apply-templates/>
  </xsl:template>
  
  <xsl:template match="fnplm:privilege[@name='admin']">admin</xsl:template>
  
  <xsl:template match="fnplm:privilege[@name='admin.readonly']">admin.readonly</xsl:template>
  
</xsl:stylesheet>
