<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin" xmlns:exsl="http://exslt.org/common" extension-element-prefixes="exsl">
  <xsl:output method="html" version="4.01" encoding="UTF-8"/>
  <xsl:include href="commonPassword.xsl"/>
  
  <xsl:variable name="expiredPassword">
    <xsl:value-of select="//fnplm:input/@expiredPassword"/>
  </xsl:variable>
  <xsl:variable name="oldPassword">
    <xsl:value-of select="//fnplm:input/@oldpassword"/>
  </xsl:variable>
  <xsl:variable name="newPassword">
    <xsl:value-of select="//fnplm:input/@newpassword"/>
  </xsl:variable>
  <xsl:variable name="confirmPassword">
    <xsl:value-of select="//fnplm:input/@confirmpassword"/>
  </xsl:variable>
  <xsl:param name="failed">
    <xsl:value-of select="//fnplm:input/@failed"/>
  </xsl:param>
  <xsl:param name="success">
    <xsl:value-of select="//fnplm:input/@success"/>
  </xsl:param>
  <xsl:variable name="save">
    <xsl:value-of select="//fnplm:input/@Save"/>
  </xsl:variable>
  <xsl:variable name="noMatch">
    <xsl:if test="$newPassword!=$confirmPassword">TRUE</xsl:if>
  </xsl:variable>
  <xsl:variable name="noPassword">
    <xsl:if test="$newPassword=''">TRUE</xsl:if>
  </xsl:variable>
  <xsl:variable name="compliance508">
    <xsl:value-of select="//fnplm:input/@compliance508"/>
  </xsl:variable>
  <xsl:variable name="location">
    <xsl:value-of select="//fnplm:input/@location"/>
  </xsl:variable>
  <xsl:variable name="cancel">
    <xsl:value-of select="//fnplm:input/@Cancel"/>
  </xsl:variable>
  <xsl:variable name="userName">
    <xsl:value-of select="extensions:getCurrentUser('xslt/userName.xsl')" disable-output-escaping="yes" />
  </xsl:variable>
  
  <xsl:variable name="changePasswordReturn">
    <xsl:if test="$save!='' and $noPassword='' and $noMatch=''">
      <xsl:value-of select="extensions:changePassword($oldPassword, $newPassword)" disable-output-escaping="yes"/> 
      <xsl:value-of select="extensions:changePasswordExpired('false')" disable-output-escaping="yes"/>
    </xsl:if>
  </xsl:variable>
  
  <xsl:template match="/">
    <xsl:choose>
      <xsl:when test="$save!='' and $noPassword='' and $noMatch='' and $changePasswordReturn=''">
        <html>
          <head>
            <script language="javascript">
              document.location.href = "/handlepassword?success=true&amp;location=<xsl:value-of select="$location"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>";
            </script>
                    
            <xsl:variable name="args">
              <xml>
                <fnplm:args>
                  <xsl:attribute name="href">/<xsl:value-of select="$location"/><xsl:if test="$compliance508='TRUE'">?compliance508=TRUE</xsl:if></xsl:attribute>
                </fnplm:args>
              </xml>
            </xsl:variable>
            <xsl:value-of select="extensions:getFormattedString('IDS_PASSWORD_CHANGE_SUCCESS_PARAMS', exsl:node-set($args)/xml/*)" disable-output-escaping="yes"/>
          </head>
        </html>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="password"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>

