<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:include href="sessionTimeout.xsl"/>

  <xsl:variable name="hostIdentificationReturn">
    <xsl:value-of select="extensions:getHostIdentification('xslt/adminSystemHostDisplay.xsl')" disable-output-escaping="yes" />
  </xsl:variable>

  <xsl:template name="systemInfo" match="/">
    <xsl:if test="starts-with($hostIdentificationReturn, 'ERROR_EXPIRED_SESSION:')">
      <xsl:call-template name="sessionTimeout"/>
    </xsl:if>
    <table class="systemInfoTable">
      <tr>
        <th><xsl:value-of select="extensions:getString('IDS_VERSION_LABEL')" disable-output-escaping="yes"/></th>
        <td><xsl:value-of select="//fnplm:input/@version"/></td>
      </tr>
      <tr>
        <th><xsl:value-of select="extensions:getString('IDS_CURRENT_PORT_LABEL')" disable-output-escaping="yes"/></th>
        <td><xsl:value-of select="//fnplm:input/@actualPort"/></td>
      </tr>
      <xsl:copy-of select="$hostIdentificationReturn"/>
      <tr>
        <th><xsl:value-of select="extensions:getString('IDS_STOP_SERVER_ALLOWED_LABEL')" disable-output-escaping="yes"/></th>
        <xsl:variable name="tempString">IDS_YES_NO_<xsl:value-of select="//fnplm:input/@stopServerAllowed"/></xsl:variable>
        <td><xsl:value-of select="extensions:getString($tempString)" disable-output-escaping="yes"/></td>
      </tr>
      <tr>
        <th><xsl:value-of select="extensions:getString('IDS_STOP_SERVER_REMOTE_ALLOWED_LABEL')" disable-output-escaping="yes"/></th>
        <xsl:variable name="tempString2">IDS_YES_NO_<xsl:value-of select="//fnplm:input/@stopServerRemoteAllowed"/></xsl:variable>
        <td><xsl:value-of select="extensions:getString($tempString2)" disable-output-escaping="yes"/></td>
      </tr>
      <tr>
        <th><xsl:value-of select="extensions:getString('IDS_LICENSE_RECLAIM_ALLOWED_LABEL')" disable-output-escaping="yes"/></th>
        <xsl:variable name="tempString3">IDS_YES_NO_<xsl:value-of select="//fnplm:input/@licenseReclaimAllowed"/></xsl:variable>
        <td><xsl:value-of select="extensions:getString($tempString3)" disable-output-escaping="yes"/></td>
      </tr>
    </table>
  </xsl:template>
</xsl:stylesheet>

