<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">

<xsl:output method="html"/>
  <xsl:param name="selectedVendor" select="''"/>
  <xsl:param name="compliance508"><xsl:value-of select="extensions:getEnv('compliance508')" disable-output-escaping="yes"/></xsl:param>
  <xsl:param name="licenseTab"><xsl:value-of select="extensions:getEnv('licenseTab')" disable-output-escaping="yes"/></xsl:param>
  <xsl:param name="selected"><xsl:value-of select="extensions:getEnv('selected')" disable-output-escaping="yes" /></xsl:param>
  <xsl:template match="/" name="adminVendorForm"><xsl:apply-templates select="//fnplm:vendor"/></xsl:template>
  <xsl:template match="//fnplm:vendor">
    <xsl:if test="./@name=$selectedVendor">
      <script language="javascript">
        function submitVendorForm(formAction, eventParam) {
          document.vendorform.elements["event"].value = eventParam;
          if (formAction != "") {
            document.vendorform.action = formAction;
          }
            
          if (eventParam != 'cancel') {
            if (eventParam == "rotatelog" <xsl:text disable-output-escaping="yes">&amp;&amp;</xsl:text> document.vendorform.elements["logName"].value == "") {
              alert("<xsl:value-of select="extensions:getString('IDS_REQUIRES_LOG_FILE')" disable-output-escaping="yes"/>");
              document.vendorform.elements["logName"].focus();
              return false;
            }
              
            if (eventParam == "save" || eventParam == "saveandreread") {
              var errors = false;
              var errorString =  "<xsl:value-of select="extensions:getString('IDS_VENDOR_CONFIG_ERRORS')" disable-output-escaping="yes"/>";
              
              document.vendorform.license.value = document.vendorform.license.value.trim();
              if (document.vendorform.license.value == "") {
                errorString += "\n - <xsl:value-of select="extensions:getString('IDS_LICENSE_FILE_OR_DIRECTORY_INVALID')" disable-output-escaping="yes"/>";
                errors = true;
              }
                
              if (document.vendorform.defaultPort[1].checked) {
                if (!document.vendorform.port.value.match(/^\d+$/) || document.vendorform.port.value <xsl:text disable-output-escaping="yes">&lt;</xsl:text> 1 || document.vendorform.port.value <xsl:text disable-output-escaping="yes">&gt;</xsl:text> 65535) {
                  errorString += "\n - <xsl:value-of select="extensions:getString('IDS_VENDOR_PORT_INVALID')" disable-output-escaping="yes"/>";
                  errors = true;
                }
              }
                
              if (!document.vendorform.restartRetries.value.match(/^\d+$/) || document.vendorform.restartRetries.value <xsl:text disable-output-escaping="yes">&lt;</xsl:text> 0) {
                errorString += "\n - <xsl:value-of select="extensions:getString('IDS_RESTART_RETRIES_INVALID')" disable-output-escaping="yes"/>";
                errors = true;
              }
                
              if (errors) {
                alert(errorString);
                return false;
              }
            }
          }
            
          document.vendorform.submit();
            
          return false;
        }
      </script>
      
      <xsl:param name="vendorName">
        <xsl:value-of select="./@name"/>
      </xsl:param>
        
      <xsl:variable name="vendorStatus">
        <xsl:value-of select="./@status"/>
      </xsl:variable>
      
      <xsl:param name="actualPort">
        <xsl:value-of select="extensions:getVendorConfig($vendorName, 'xslt/vendorPort.xsl')" disable-output-escaping="yes"/>
      </xsl:param>

      <xsl:if test="$actualPort!=''">
        <strong><xsl:value-of select="extensions:getString('IDS_CURRENT_VENDOR_PORT_LABEL')" disable-output-escaping="yes"/></strong><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
        <xsl:value-of select="$actualPort"/>
        <br/>
        <br/>
      </xsl:if>
      <h2><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="extensions:getString('IDS_VENDOR_DAEMON_ACTIONS_HEADER')" disable-output-escaping="yes"/></h2>
        
      <form action="/vendor" method="post" name="vendorform" enctype="multipart/form-data" id='looseCheck'>
        <input type="hidden" name="event"/>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="checksum" value="<xsl:value-of select="extensions:setChecksum('vendorform')"/>" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="licenseTab" value="<xsl:value-of select="$licenseTab"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="selected" value="<xsl:value-of select="$selected"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        <xsl:if test="$compliance508='TRUE'">
          <input type="hidden" name="compliance508" value="TRUE"/>
        </xsl:if>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="vendor" value="<xsl:value-of select="./@name"/>" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        <xsl:choose>
          <xsl:when test="$vendorStatus='IDS_RUNNING'">
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="button" name="StopDaemon" value="<xsl:value-of select="extensions:getString('IDS_STOP_VENDOR_DAEMON_LABEL')" disable-output-escaping="yes"/>" class="button" onmouseover="this.className='button buttonHover'" onmouseout="this.className='button'" style="width: 100px;" onClick="return submitVendorForm('/vendor', 'stop')" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
            <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="button" name="Reread" value="<xsl:value-of select="extensions:getString('IDS_REREAD_LICENSE_FILE_LABEL')" disable-output-escaping="yes"/>" class="button" onmouseover="this.className='button buttonHover'" onmouseout="this.className='button'" style="width:auto;overflow:visible;padding-right:20px;padding-left:20px;" onClick="return submitVendorForm('/vendor', 'reread')" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
            <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
            <br/>
            <br/>
            <strong>
              <xsl:value-of select="extensions:getString('IDS_REPORT_LOG_LABEL')" disable-output-escaping="yes"/>
            </strong>
            <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
            <input type="text" size="40" id="log" name="logName" class="textField"/>
            <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="button" name="Rotate" value="<xsl:value-of select="extensions:getString('IDS_ROTATE_REPORT_LOG_LABEL')" disable-output-escaping="yes"/>" class="buttonBig" onmouseover="this.className='buttonBig buttonHover'" onmouseout="this.className='buttonBig'" style="width:auto;overflow:visible;padding-right:20px;padding-left:20px;" onClick="return submitVendorForm('/vendor', 'rotatelog')" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="button" name="StartDaemon" value="<xsl:value-of select="extensions:getString('IDS_START_VENDOR_DAEMON_LABEL')" disable-output-escaping="yes"/>" class="button" onmouseover="this.className='button buttonHover'" onmouseout="this.className='button'" style="width: 100px;" onClick="return submitVendorForm('/vendor', 'start')" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
            <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
        <br/>
        <br/>
        <table cellpadding="0" width="850" height="460">
          <tr valign="top">
            <td>
              <xsl:value-of select="extensions:getVendorConfig($vendorName, 'xslt/vendorConfig.xsl')" disable-output-escaping="yes"/>
              <div align="right">
                <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="submit" name="SaveConfig" value="<xsl:value-of select="extensions:getString('IDS_SAVE_LABEL')" disable-output-escaping="yes"/>" class="button" onmouseover="this.className='button buttonHover'" onmouseout="this.className='button'" onClick="return submitVendorForm('/vendor', 'save')" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="button" name="Cancel" value="<xsl:value-of select="extensions:getString('IDS_CANCEL_LABEL')" disable-output-escaping="yes"/>" class="button" onmouseover="this.className='button buttonHover'" onmouseout="this.className='button'" onClick="return submitVendorForm('/vendor', 'cancel')" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
              </div>
            </td>
          </tr>
        </table>
      </form>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>
