<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin"  xmlns:exsl="http://exslt.org/common" extension-element-prefixes="exsl">
  <xsl:output method="html"/>
  
  <xsl:template match="/" name="autoLogin">
    <html>
      <body>
        <form action="/handlesignin" method="post" name="autoLogin">
          <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="checksum" value="<xsl:value-of select="extensions:setChecksum('autoLogin')"/>" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
          <input type="hidden" name="username" value=""/>
          <input type="hidden" name="password" value=""/>
          <xsl:if test="$compliance508='TRUE'">
            <input type="hidden" name="compliance508" value="TRUE"/>
            <xsl:value-of select="extensions:getString('IDS_AUTO_LOGIN_MESSAGE')" disable-output-escaping="yes"/>
          </xsl:if>
        </form>
        
        <script language="javascript">
          document.autoLogin.submit();
        </script>
        <xsl:if test="$compliance508!='TRUE'">
          <noscript>
            <p class="importErrorText"><b><xsl:value-of select="extensions:getString('IDS_JAVASCRIPT_DISABLED')" disable-output-escaping="yes"/></b></p>
          </noscript>
        </xsl:if>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
