<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin" xmlns:exsl="http://exslt.org/common" extension-element-prefixes="exsl">
  <xsl:output method="html" version="4.01"/>
  <xsl:include href="adminNav.xsl"/>
  <xsl:include href="helpAdmin.xsl"/>
  <xsl:include href="footer.xsl"/>
  <xsl:include href="adminSystem.xsl"/>
  <xsl:include href="adminUsers.xsl"/>
  <xsl:include href="adminAlerts.xsl"/>
  <xsl:include href="adminVendor.xsl"/>
  <xsl:include href="adminSystemInfo.xsl"/>
  <xsl:include href="header.xsl"/>
  <xsl:include href="headerNav.xsl"/>
  
  <xsl:param name="isAdmin"><xsl:value-of select="extensions:hasPrivilege('admin')" disable-output-escaping="yes" /></xsl:param>
  <xsl:variable name="protectDashboard">
    <xsl:value-of select="extensions:getPreference('protectDashboard')" disable-output-escaping="yes"/>
  </xsl:variable>
  
  <xsl:param name="failed">
    <xsl:choose>
      <xsl:when test="//fnplm:input/@failed!=''"><xsl:value-of select="//fnplm:input/@failed"/></xsl:when>
      <xsl:when test="starts-with($isAdmin, 'ERROR_EXPIRED_SESSION:')">sessiontimeout</xsl:when>
    </xsl:choose>
  </xsl:param>
  <xsl:param name="test"><xsl:value-of select="//fnplm:input/@test"/></xsl:param>
  <xsl:param name="login">
    <xsl:choose>
      <xsl:when test="$isAdmin!=''">TRUE</xsl:when>
      <xsl:otherwise>FALSE</xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  <xsl:param name="dashboard" select="'FALSE'"/>
  <xsl:variable name="location">
    <xsl:choose>
      <xsl:when test="$admin='USERS'">users</xsl:when>
      <xsl:when test="$admin='ALERTS'">alerts</xsl:when>
      <xsl:when test="$admin='CONFIG'">admin</xsl:when>
      <xsl:when test="$admin='VENDOR'">vendor</xsl:when>
      <xsl:when test="$admin='SYSTEMINFO'">systeminfo</xsl:when>
    </xsl:choose>
  </xsl:variable>

  <xsl:template match="/" name="admin"> 
    <xsl:text disable-output-escaping="yes">&lt;!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"&gt;</xsl:text>

    <html>
      <head>
        <xsl:call-template name="header"/>
        
        <script language="JavaScript" type="text/javascript">
          function init() {
            var stretchers = document.getElementsByClassName('stretcher'); 
            var toggles = document.getElementsByClassName('display');

            var myAccordion = new fx.Accordion(toggles, stretchers, {opacity: true, duration: 150});

            function checkHash() {
              var found = false;
              toggles.each(function(h3, i) {
                if (window.location.href.indexOf(h3.title) > 0) {
                  myAccordion.showThisHideOpen(stretchers[i]);
                  found = true;
                }
              });
            
              return found;
            }

            if (!checkHash()) myAccordion.showThisHideOpen(stretchers[0]);
          }
        </script>
      </head>
      <body>
        <div id="shell">
          <div id="wrapper">
            <div id="outer">
              <div id="center">
                <div id="clearheadercenter"></div>
                  <div id="containerCenter">
                    <div class="content">
                      <div class="contentSpacer">
                        <xsl:choose>
                          <xsl:when test="$login='TRUE'">
                            <xsl:variable name="args">
                              <xml>
                                <fnplm:args>
                                  <xsl:attribute name="href">
                                    <xsl:choose>
                                      <xsl:when test="$compliance508!='TRUE'">/signin?admin=true&amp;location=<xsl:value-of select="$location"/>&amp;vendor=<xsl:value-of select="$vendorEnv"/>&amp;licenseTab=<xsl:value-of select="$licenseTabEnv"/>&amp;selected=<xsl:value-of select="$selectedEnv"/></xsl:when>
                                      <xsl:otherwise>/login508?admin=true&amp;location=<xsl:value-of select="$location"/>&amp;compliance508=TRUE&amp;vendor=<xsl:value-of select="$vendorEnv"/>&amp;licenseTab=<xsl:value-of select="$licenseTabEnv"/>&amp;selected=<xsl:value-of select="$selectedEnv"/></xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:attribute>
                                </fnplm:args>
                              </xml>
                            </xsl:variable>
                            <xsl:value-of select="extensions:getFormattedString('IDS_ADMIN_LOGIN_MESSAGE', exsl:node-set($args)/xml/*)" disable-output-escaping="yes"/>
                          </xsl:when>
                          <xsl:when test="$admin='USERS'">
                            <xsl:call-template name="adminUsers"/>
                          </xsl:when>
                          <xsl:when test="$admin='ALERTS'">
                            <xsl:call-template name="adminAlerts"/>
                          </xsl:when>
                          <xsl:when test="$admin='CONFIG'">
                            <xsl:call-template name="adminSystem"/>
                          </xsl:when>
                          <xsl:when test="$admin='VENDOR'">
                            <xsl:call-template name="adminVendor"/>
                          </xsl:when>
                          <xsl:when test="$admin='SYSTEMINFO'">
                            <xsl:call-template name="adminSystemInfo"/>
                          </xsl:when>
                        </xsl:choose>
                      </div>
                    </div>
                    <div id="containerCenterFooter"><xsl:value-of select="extensions:getString('IDS_ACRESSO_COPYRIGHT')" disable-output-escaping="yes"/></div>
                  </div>
                  <div class="password">
                    <xsl:variable name="localeCount">
                      <xsl:value-of select="extensions:getLocaleList('xslt/localeCount.xsl')" disable-output-escaping="yes" />
                    </xsl:variable>
                    <xsl:variable name="userType">
                      <xsl:value-of select="extensions:getCurrentUser('xslt/userType.xsl')" disable-output-escaping="yes" />
                    </xsl:variable>
                    <xsl:choose>
                      <xsl:when test="$compliance508!='TRUE'">
                        <xsl:if test="$protectDashboard='true' or $isAdmin=''">
                           <xsl:if test="starts-with($userType, 'local')"> 
                             <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="#" onClick="mypanelPassword.show(); return GB_show('password', 'password?location=<xsl:value-of select="$location"/>', 270, 328);"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_CHANGE_PASSWORD_LABEL')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                           </xsl:if>
                        </xsl:if>
                        <xsl:if test="$localeCount > 1">
                          <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="#" onClick="mypanelPassword.show(); return GB_show('locale', 'locale?location=<xsl:value-of select="$location"/>', 270, 328);"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_CHANGE_LOCALE_LABEL')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                        </xsl:if>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:if test="$protectDashboard='true' or $isAdmin='' or starts-with($userType, 'local')">
                          <xsl:if test="starts-with($userType, 'local')"> 
                            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="/password?compliance508=TRUE&amp;location=<xsl:value-of select="$location"/>"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_CHANGE_PASSWORD_LABEL')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                          </xsl:if>
                        </xsl:if>
                        <xsl:if test="$localeCount > 1">
                          <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="/locale?compliance508=TRUE&amp;location=<xsl:value-of select="$location"/>"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_CHANGE_LOCALE_LABEL')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                        </xsl:if>
                      </xsl:otherwise>
                    </xsl:choose>
                  </div>
                </div>
                
                <xsl:call-template name="adminNav"/>
              </div>
          </div>
          <xsl:call-template name="headerNav"/>
        </div>
        <xsl:call-template name="footer"/>
        
        <xsl:if test="$login!='TRUE' and $admin='CONFIG'">
          <script type="text/javascript">
            Element.cleanWhitespace('accordionContent');
            init();
          </script>
        </xsl:if>
      </body>
    </html>

  </xsl:template>
</xsl:stylesheet>
