<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:output method="text" encoding="UTF-8"/>
  <xsl:template match="/" name="fulfillments">
    <xsl:value-of select="extensions:getString('IDS_EXPORT_PRODUCT_NAME_HEADER')" disable-output-escaping="yes"/><xsl:value-of select="extensions:getString('IDS_EXPORT_SEPARATOR')" disable-output-escaping="yes"/><xsl:value-of select="extensions:getString('IDS_EXPORT_PRODUCT_VERSION_HEADER')" disable-output-escaping="yes"/><xsl:value-of select="extensions:getString('IDS_EXPORT_SEPARATOR')" disable-output-escaping="yes"/><xsl:value-of select="extensions:getString('IDS_EXPORT_SUITE_HEADER')" disable-output-escaping="yes"/>
    <xsl:apply-templates select="xml/fnplm:fulfillments" />
  </xsl:template>
  
  <xsl:template match="fnplm:fulfillments">
    <xsl:text>&#10;</xsl:text><xsl:value-of select="./@productname" /><xsl:value-of select="extensions:getString('IDS_EXPORT_SEPARATOR')" disable-output-escaping="yes"/><xsl:value-of select="./@versionname" /><xsl:value-of select="extensions:getString('IDS_EXPORT_SEPARATOR')" disable-output-escaping="yes"/><xsl:value-of select="extensions:getString('IDS_NO')" disable-output-escaping="yes"/>
    <xsl:text>&#10;</xsl:text><xsl:value-of select="extensions:getString('IDS_EXPORT_FEATURES_HEADER')" disable-output-escaping="yes"/>
    <xsl:apply-templates select="//fnplm:fulfillment/@lines"/>
    <xsl:text>&#10;</xsl:text><xsl:value-of select="extensions:getString('IDS_EXPORT_FULFILLMENT_RECORD_ID_HEADER')" disable-output-escaping="yes"/><xsl:value-of select="extensions:getString('IDS_EXPORT_SEPARATOR')" disable-output-escaping="yes"/><xsl:value-of select="extensions:getString('IDS_EXPORT_QUANTITY_HEADER')" disable-output-escaping="yes"/><xsl:value-of select="extensions:getString('IDS_EXPORT_SEPARATOR')" disable-output-escaping="yes"/><xsl:value-of select="extensions:getString('IDS_EXPORT_EXPIRATION_HEADER')" disable-output-escaping="yes"/><xsl:value-of select="extensions:getString('IDS_EXPORT_SEPARATOR')" disable-output-escaping="yes"/><xsl:value-of select="extensions:getString('IDS_EXPORT_TYPE_HEADER')" disable-output-escaping="yes"/><xsl:value-of select="extensions:getString('IDS_EXPORT_SEPARATOR')" disable-output-escaping="yes"/><xsl:value-of select="extensions:getString('IDS_EXPORT_SERVER_CHAIN_HEADER')" disable-output-escaping="yes"/><xsl:value-of select="extensions:getString('IDS_EXPORT_SEPARATOR')" disable-output-escaping="yes"/><xsl:value-of select="extensions:getString('IDS_EXPORT_REPAIR_COUNT_HEADER')" disable-output-escaping="yes"/>
    <xsl:apply-templates select="fnplm:fulfillment" />
  </xsl:template>
  
  <xsl:template match="fnplm:fulfillment">
    <xsl:text>&#10;</xsl:text><xsl:value-of select="./@fulfillmentid" /><xsl:value-of select="extensions:getString('IDS_EXPORT_SEPARATOR')" disable-output-escaping="yes"/>
    <xsl:variable name="activatable"><xsl:value-of select="./@activatablecount" /></xsl:variable>
    <xsl:variable name="overdraft">
      <xsl:choose>
        <xsl:when test="./@availableActivationOverdrafts!=''"><xsl:value-of select="./@availableActivationOverdrafts"/></xsl:when>
        <xsl:otherwise>0</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:value-of select="$activatable+$overdraft" /><xsl:value-of select="extensions:getString('IDS_EXPORT_SEPARATOR')" disable-output-escaping="yes"/>
    <xsl:value-of select="extensions:getNumberedDate(./@expiration)" /><xsl:value-of select="extensions:getString('IDS_EXPORT_SEPARATOR')" disable-output-escaping="yes"/>
    <xsl:value-of select="extensions:getString('IDS_ACTIVATION')" disable-output-escaping="yes"/><xsl:value-of select="extensions:getString('IDS_EXPORT_SEPARATOR')" disable-output-escaping="yes"/>
    <xsl:value-of select="./@activationchain" /><xsl:value-of select="extensions:getString('IDS_EXPORT_SEPARATOR')" disable-output-escaping="yes"/>
    <xsl:value-of select="./@repaircount" />
  </xsl:template>
  
  <xsl:template match="//fnplm:fulfillment/@lines">
    <xsl:text>&#10;</xsl:text><xsl:value-of select="." disable-output-escaping="yes"/>
  </xsl:template>
</xsl:stylesheet>
