<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:param name="help_id"><xsl:value-of select="//fnplm:input/@id"/></xsl:param>
  
  <xsl:template match="/" name="help">
    <html>
      <head>
        <title><xsl:value-of select="extensions:getString('IDS_HELP_TITLE')" disable-output-escaping="yes"/></title>
        
        <xsl:choose>
          <xsl:when test="$compliance508!='TRUE'">
            <link rel="stylesheet" type="text/css" href="resources/content.css"/>
            <link rel="stylesheet" type="text/css" href="resources/structure.css"/>
            <link rel="stylesheet" type="text/css" href="resources/veneer.css"/>
            <link rel="stylesheet" type="text/css" href="resources/veneerPopup.css"/>
          </xsl:when>
          <xsl:otherwise>
            <link rel="stylesheet" type="text/css" href="resources/508/content.css"/>
            <link rel="stylesheet" type="text/css" href="resources/508/structure.css"/>
            <link rel="stylesheet" type="text/css" href="resources/508/veneer.css"/>
            <link rel="stylesheet" type="text/css" href="resources/508/veneerPopup.css"/>
          </xsl:otherwise>
        </xsl:choose>
        <script type="text/javascript" src="resources/standard.js"></script>
        <script type="text/javascript" src="resources/ajax.js"></script>
        <script type="text/javascript" src="resources/tableSorter.js"></script>
        <script type="text/javascript" src="resources/yahoofiles/yp_files/yahoo.js" ></script>
        <script type="text/javascript" src="resources/yahoofiles/yp_files/event.js" ></script>
        <script type="text/javascript" src="resources/yahoofiles/yp_files/dom.js" ></script>
        <script type="text/javascript" src="resources/yahoofiles/yp_files/dragdrop.js" ></script>
        <script type="text/javascript" src="resources/yahoofiles/yp_files/animation.js" ></script>
        <script type="text/javascript" src="resources/yahoofiles/yp_files/container.js"></script>
      
        <meta http-equiv="Cache-Control" content="no-cache"/>
        <meta http-equiv="Pragma" content="no-cache"/>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
      </head>

      <body>
        <div class="containerCenter">
          <div class="contentSpacer">
            <div id="leftContent">
              <xsl:value-of select="extensions:getString($help_id)" disable-output-escaping="yes"/>
            </div>
          </div>
        </div>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>


