<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:output method="html" version="4.01" encoding="UTF-8"/>
  <xsl:include href="commonDashboard.xsl"/>
  <xsl:include href="sessionTimeout.xsl"/>
  <xsl:include href="autoLogin.xsl"/>
  
  <xsl:param name="login" select="'TRUE'"/>
  <xsl:param name="failed"><xsl:value-of select="//fnplm:input/@failed"/></xsl:param>
  <xsl:param name="test"><xsl:value-of select="//fnplm:input/@test"/></xsl:param>
  <xsl:param name="isMaster">TRUE</xsl:param>
  <xsl:param name="tempMasterName"/>
  <xsl:variable name="visibleLicenseValue">
    <xsl:variable name="getPreferenceReturn">
      <xsl:value-of select="extensions:getPreference('visibleLicense')" disable-output-escaping="yes" />
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$getPreferenceReturn='' or substring-after($getPreferenceReturn, ':')!=''">3</xsl:when>
      <xsl:otherwise><xsl:value-of select="$getPreferenceReturn"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="protectDashboard">
    <xsl:value-of select="extensions:getPreference('protectDashboard')" disable-output-escaping="yes"/>
  </xsl:variable>
  <xsl:param name="licenseTab">
    <xsl:choose>
      <xsl:when test="$visibleLicenseValue=2">floating</xsl:when>
      <xsl:otherwise><xsl:value-of select="//fnplm:input/@licenseTab" /></xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  <xsl:param name="selectedVendor">
    <xsl:value-of select="extensions:getVendorList('', 'xslt/vendorByIndex.xsl')" disable-output-escaping="yes" />
  </xsl:param>
  <xsl:param name="compliance508"><xsl:value-of select="//fnplm:input/@compliance508"/></xsl:param>
  <xsl:param name="admin"></xsl:param>
  <xsl:param name="location"/>
  
  <xsl:template match="/" name="login">
    <xsl:choose>
      <xsl:when test="$protectDashboard='false'"><xsl:call-template name="autoLogin"/></xsl:when>
      <xsl:otherwise><xsl:call-template name="dashboard"/></xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>


