<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:output method="html" version="4.01" encoding="UTF-8"/>
  <xsl:include href="commonAdmin.xsl"/>
  <xsl:include href="sessionTimeout.xsl"/>
  <xsl:variable name="help_id">HELP_IDS_ADMIN</xsl:variable>

  <xsl:param name="admin" select="'CONFIG'"/>
  <xsl:param name="compliance508"><xsl:value-of select="//fnplm:input[@name='compliance508']"/></xsl:param>
  <xsl:param name="visibleLicense"><xsl:value-of select="//fnplm:input[@name='visibleLicense']"/></xsl:param>
  <xsl:param name="protectDashboardValue">
    <xsl:choose>
      <xsl:when test="//fnplm:input[@name='protectDashboard']!=''"><xsl:value-of select="//fnplm:input[@name='protectDashboard']"/></xsl:when>
      <xsl:otherwise>false</xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  <xsl:param name="defaultLocaleValue"><xsl:value-of select="//fnplm:input[@name='defaultLocale']"/></xsl:param>
  <xsl:param name="action"><xsl:value-of select="//fnplm:input[@name='event']"/></xsl:param>
  <xsl:param name="sysConfigchecksum"><xsl:value-of select="//fnplm:input[@name='checksum']"/></xsl:param>
  <xsl:param name="cancel">
    <xsl:choose>
      <xsl:when test="$action='cancel'">Cancel</xsl:when>
      <xsl:otherwise><xsl:value-of select="//fnplm:input[@name='Cancel']"/></xsl:otherwise>
    </xsl:choose>
  </xsl:param>

  <xsl:param name="EventAction">
    <xsl:choose>
      <xsl:when test="$action='cancel'">Cancel</xsl:when>
      <xsl:otherwise>Save</xsl:otherwise>
    </xsl:choose>
  </xsl:param>  
  
  <xsl:variable name="logConfig">
      <xsl:copy-of select="//fnplm:input[@name='logLevel']"/>
  </xsl:variable>

  <xsl:param name="httpsPort">
    <xsl:value-of select="//fnplm:input[@name='websecureport']"/>
  </xsl:param>
  <xsl:param name="isHttpsEnabled">
    <xsl:choose>
      <xsl:when test="$httpsPort > 0">TRUE</xsl:when>
      <xsl:otherwise></xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  <xsl:param name="wasHttpsEnabled"><xsl:value-of select="//fnplm:input[@name='waswebsecureportenabled']"/></xsl:param>
  <xsl:param name="isHttpsRedirect"><xsl:value-of select="//fnplm:input[@name='webredirecthttp']"/></xsl:param>
  <xsl:param name="wasHttpsRedirect"><xsl:value-of select="//fnplm:input[@name='waswebsecurehttpredirect']"/></xsl:param> 
  
  <xsl:variable name="inXML" select="//xml/*"/>
  <xsl:variable name="saveLicenseServerReturn">
    <xsl:if test="$cancel=''">
      <xsl:choose>
        <xsl:when test="$action='stop'">
          <xsl:value-of select="extensions:requestShutdown($sysConfigchecksum)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="tempLogConfig">
            <xsl:value-of select="extensions:setLogConfig('root', $inXML, '')"/>
          </xsl:variable>

          <xsl:choose>
            <xsl:when test="$tempLogConfig=''">
              <xsl:variable name="tempSetPreference">
                <xsl:value-of select="extensions:setPreference('visibleLicense', $visibleLicense, $sysConfigchecksum)" disable-output-escaping="yes" />
              </xsl:variable>

              <xsl:choose>
                <xsl:when test="$tempSetPreference=''">
                  <xsl:variable name="tempSetPreference2">
                    <xsl:value-of select="extensions:setPreference('protectDashboard', $protectDashboardValue, $sysConfigchecksum)" disable-output-escaping="yes" />
                  </xsl:variable>

                  <xsl:choose>
                    <xsl:when test="$tempSetPreference2=''">
                      <xsl:variable name="tempSetPreference3">
                        <xsl:value-of select="extensions:setPreference('defaultLocale', $defaultLocaleValue, $sysConfigchecksum)" disable-output-escaping="yes" />
                      </xsl:variable>

                      <xsl:choose>
                        <xsl:when test="$tempSetPreference3=''">
                          <xsl:value-of select="extensions:setSystemConfiguration($inXML)"/>
                        </xsl:when>
                        <xsl:otherwise><xsl:value-of select="$tempSetPreference3"/></xsl:otherwise>
                      </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise><xsl:value-of select="$tempSetPreference2"/></xsl:otherwise>
                  </xsl:choose>
                </xsl:when>
                <xsl:otherwise><xsl:value-of select="$tempSetPreference"/></xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:otherwise><xsl:value-of select="$tempLogConfig"/></xsl:otherwise>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </xsl:variable>
    
  <xsl:param name="message">
    <xsl:if test="$cancel=''">
      <xsl:choose>
        <xsl:when test="$saveLicenseServerReturn=''">
          <xsl:choose>
            <xsl:when test="$action='stop'">IDS_SHUTDOWN_MESSAGE</xsl:when>
            <xsl:otherwise>SAVE_OK</xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:when test="$saveLicenseServerReturn='WARNING'">SAVE_OK_WARNING</xsl:when>
        <xsl:when test="substring-after($saveLicenseServerReturn, ':')!=''">
          <xsl:value-of select="substring-after($saveLicenseServerReturn, ':')"/>
        </xsl:when>
        <xsl:otherwise><xsl:value-of select="$eventResult"/></xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </xsl:param>

  <xsl:template match="/">
    <xsl:if test="starts-with($saveLicenseServerReturn, 'ERROR_EXPIRED_SESSION:')">
      <xsl:call-template name="sessionTimeout"/>
    </xsl:if>
    <xsl:call-template name="admin"/>
  </xsl:template>
</xsl:stylesheet>
