#!/bin/bash
#
# Copyright (C) 2010-2018 NanoXplore. All Rights Reserved.
#
# This wrapper script should never be moved from the install directory.

function fatal
{
    echo "$program: error: $*" >&2 && exit 1
}

# Find the directory that this script lives in.
program=`basename $0`
thisdir=$(cd `dirname $BASH_SOURCE` && /bin/pwd)

# Find the canonical system name.
NANOXPLORE_SYSTEM=unknown
PYTHON_NEEDED=2.7
COMMAND=unknown

if [ "x$NANOXPLORE_BYPASS" != "x" ]; then
    # bypass an analysis and use a specific exec from $NANOXPLORE_BYPASS
    NANOXPLORE_SYSTEM=$NANOXPLORE_BYPASS
    echo "$program: bypassing system analysis and using $NANOXPLORE_BYPASS"
else
    UNAME_SYSTEM=`(uname -s) 2> /dev/null`  || UNAME_SYSTEM=unknown
    UNAME_MACHINE=`(uname -m) 2> /dev/null` || UNAME_MACHINE=unknown
    UNAME_RELEASE=`(uname -r) 2>/dev/null` || UNAME_RELEASE=unknown

    case "${UNAME_SYSTEM}:${UNAME_MACHINE}:${UNAME_RELEASE}" in
        Linux:x86_64:*)
            (grep -qs 'release 6' /etc/redhat-release > /dev/null 2>&1) && NANOXPLORE_SYSTEM=x86_64_RHEL_6 && PYTHON_NEEDED=2.6 && COMMAND=yum
            (grep -qs 'release 7' /etc/redhat-release > /dev/null 2>&1) && NANOXPLORE_SYSTEM=x86_64_RHEL_7 && PYTHON_NEEDED=2.7 && COMMAND=yum
            (grep -iqs 'Ubuntu' /etc/os-release) && (grep -q '14.04' /etc/os-release) && NANOXPLORE_SYSTEM=x86_64_UBUNTU_14 && PYTHON_NEEDED=2.7 && COMMAND=apt-get
            (grep -iqs 'Ubuntu' /etc/os-release) && (grep -q '16.04' /etc/os-release) && NANOXPLORE_SYSTEM=x86_64_UBUNTU_16 && PYTHON_NEEDED=2.7 && COMMAND=apt-get
            (grep -iqs 'Ubuntu' /etc/os-release) && (grep -q '18.04' /etc/os-release) && NANOXPLORE_SYSTEM=x86_64_UBUNTU_18 && PYTHON_NEEDED=2.7 && COMMAND=apt-get
            (grep -iqs 'Debian' /etc/os-release) && (grep -q '9 (stretch)' /etc/os-release) && NANOXPLORE_SYSTEM=x86_64_DEBIAN_9 && PYTHON_NEEDED=2.7 && COMMAND=apt-get
            ;;
        *)
            fatal "unsupported platform: $UNAME_SYSTEM $UNAME_RELEASE ($UNAME_MACHINE)" ;;
    esac
    test "x$NANOXPLORE_SYSTEM" = "xunknown" && fatal "unable to guess current system type"
fi

NANOXPLORE_SYSTEM=$NANOXPLORE_SYSTEM$COMP_MODE

# Find the installation prefix.
NANOXPLORE_PREFIX=`cd $thisdir/.. && /bin/pwd`

# Export our environement.
LIBRARY_PATH=$NANOXPLORE_PREFIX/lib64/$NANOXPLORE_SYSTEM

LD_LIBRARY_PATH="$LIBRARY_PATH${LD_LIBRARY_PATH:+:$LD_LIBRARY_PATH}"
DYLD_LIBRARY_PATH="$LIBRARY_PATH${LD_LIBRARY_PATH:+:$DYLD_LIBRARY_PATH}"

PYTHONPATH="$LIBRARY_PATH:$NANOXPLORE_PREFIX/share/python${PYTHONPATH:+:$PYTHONPATH}"

export NANOXPLORE_SYSTEM NANOXPLORE_PREFIX LD_LIBRARY_PATH DYLD_LIBRARY_PATH PYTHONPATH

export NXP_PROGRAM=$thisdir/$program

export LANG="en_US.UTF-8"
