#!/bin/bash
#
# Copyright (C) 2010-2018 NanoXplore. All Rights Reserved.
#
# This wrapper script should never be moved from the install directory.

function fatal
{
    echo "$program: error: $*" >&2 && exit 1
}

# Find the directory that this script lives in.
program=`basename $0`
thisdir=$(cd `dirname $0` && /bin/pwd)

. $thisdir/env.sh

PYTHON_VERSION=`/usr/bin/env python -c 'import sys; print(".".join(map(str, sys.version_info[:2])))'`

if [ $program = "nanoxmap" ]
then
    echo "WARNING | '$program' command is deprecated and will be removed in future version."
    echo "        | Please use 'nxmap' command instead."
    echo "        |"

    program="nxmap"
fi

if [ $program = "nanoxpython" ]
then
    echo "WARNING | '$program' command is deprecated and will be removed in future version."
    echo "        | Please use 'nxpython' command instead."
    echo "        |"

    program="nxpython"
fi

if [ ! -d $thisdir/$NANOXPLORE_SYSTEM ]; then
    fatal "missing binary programs directory: $thisdir/$NANOXPLORE_SYSTEM"
fi

if [ "$program" != "nxpython" ]; then
    if [ ! -x $thisdir/$NANOXPLORE_SYSTEM/$program ]; then
	fatal "missing binary for program $program in $thisdir/$NANOXPLORE_SYSTEM"
    fi
fi

if [ "$PYTHON_VERSION" == "" ]
then
    echo "$program needs Python $PYTHON_NEEDED"
    echo ""
    echo " contact admin to install it"
    exit 1
fi

if [ "$PYTHON_VERSION" != "$PYTHON_NEEDED" ]
then
    echo "$program needs Python $PYTHON_NEEDED on this platform"
    echo "  found version $PYTHON_VERSION"
    exit 2
fi


# Run the actual program with arguments.
if [ "$program" == "nxpython" ]; then

    export NANOXPYTHON_GUI=OFF

    while :
    do
        case $1 in
            -h|-help)
                exec python -c "from nanoxmap import*; usage()"
                exit
                ;;
            -v|-version)
                exec python -c "from nanoxmap import*; version()"
                exit
                ;;
            -g|-gui)
                export NANOXPYTHON_GUI=ON
                shift
                ;;
            *)
                break
        esac
    done

    exec python "$@"
else

    exec $thisdir/$NANOXPLORE_SYSTEM/$program "$@"
fi
