import os
import sys

from nanoxmap import *

dir = os.path.dirname(os.path.realpath(__file__))

project = createProject(dir)

project.setVariantName('NG-MEDIUM')

project.setTopCellName('Systolic_hier')

project.addFiles(['src/Systolic_cell.vhd', 'src/Systolic_hier.vhd'])

project.setOptions({
   'MergeRegisterToPad': 'Never', # 'Always',
   'ManageUnconnectedSignals': 'Ground',
   })

project.createClock('getClockNet(CLK)', 'CLK', 5000, 0, 2500)

project.save('native.nxm')

if not project.synthesize():
    sys.exit(1)

project.save('_synthese.vhd')
project.save('synthesized.nxm')

if not project.place():
    sys.exit(1)

project.save('placed.nxm')

if not project.route():
    sys.exit(1)

project.save('routed.nxm')

analyzer = project.createAnalyzer()
analyzer.launch(50)

print 'Errors: ', getErrorCount()
print 'Warnings: ', getWarningCount()
