library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_arith.ALL;
use IEEE.STD_LOGIC_signed.ALL;

-- This source code describes a single channel FIR Filter implemented on the Systolic structure
-- The N-tap FIR implementation requires N DSP blocks

entity Systolic_cell is
generic ( 
   DIN_width : integer range 8 to 18 := 18;
   Coefs_width : integer range 8 to 18 := 18;
   Output_width : integer range 8 to 50 := 18 
   );
port ( 
   CLK   : in  STD_LOGIC;
   COEF  : in std_logic_vector(Coefs_width-1 downto 0);
   DATA_CHAIN_IN   : in  std_logic_vector(DIN_width-1 downto 0);
   DATA_CHAIN_OUT  : out std_logic_vector(DIN_width-1 downto 0);
   ADD_CHAIN_IN    : in std_logic_vector(DIN_width + Coefs_width-1 + 3 downto 0);
   ADD_CHAIN_OUT   : out std_logic_vector(DIN_width + Coefs_width-1 + 3 downto 0)
   );
end Systolic_cell;

architecture ARCHI of Systolic_cell is

signal DINR1, DINR2 : std_logic_vector(DIN_width-1 downto 0);
signal COEFR : std_logic_vector(DIN_width-1 downto 0);

signal MULT : std_logic_vector(DIN_width + Coefs_width - 1 downto 0);
attribute NX_USE : string;
attribute NX_USE of MULT : signal is "NX_DSP";

begin

process(CLK)  begin
   if rising_edge(CLK)  then
      DINR1 <= DATA_CHAIN_IN;
      DINR2 <= DINR1;
      COEFR <= COEF;
      MULT <= DINR2 * COEFR;
      ADD_CHAIN_OUT <= ADD_CHAIN_IN + MULT;
   end if;
end process;      
   
DATA_CHAIN_OUT <= DINR2;   
   
end ARCHI;   

