library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_arith.ALL;
use IEEE.STD_LOGIC_signed.ALL;

entity TB_TRANSPOSE_SYM_FLAT_synth is
end TB_TRANSPOSE_SYM_FLAT_synth;

architecture Behavioral of TB_TRANSPOSE_SYM_FLAT_synth is

component TRANSPOSE_SYM_FLAT 
port ( 
   CLK : in  STD_LOGIC;
   DIN : in std_logic_vector (11 downto 0);
   DOUT : out std_logic_vector (15 downto 0)
   );
end component;

signal CLK : std_logic := '0';
signal DIN : std_logic_vector(11 downto 0) := (others => '0');
signal DOUT : std_logic_vector(15 downto 0) := (others => '0');

begin

process  begin
   CLK <= '0';  wait for 5 ns;
   CLK <= '1';  wait for 5 ns;
end process;   

process  begin
   DIN <= (others => '0');
   wait for 250 ns;
   DIN <= (8  => '1', others => '0');  -- Positive pulse (1/8 max positive)
   wait for 10 ns;
   DIN <= (others => '0');

   wait for 300 ns;
   DIN <= (11 downto 8 => '1', others => '0');  -- Negative pulse (max negative)
   wait for 10 ns;
   DIN <= (others => '0');

   wait for 300 ns;
   DIN <= (11 => '1', others => '0');  -- Negative pulse (max negative)
   wait for 10 ns;
   DIN <= (others => '0');
   wait for 300 ns;

   DIN <= (11 => '0', others => '1'); -- Positive step (max positive)
   wait for 300 ns;
   DIN <= (others => '0');
   wait for 300 ns;

   DIN <= (11 => '1', others => '0'); -- Negative step (max negative)
   wait for 300 ns;
   DIN <= (others => '0');
   wait for 300 ns;
   
   wait;
end process;   

FUT : TRANSPOSE_SYM_FLAT 
port map( 
   CLK  => CLK,
   DIN  => DIN,
   DOUT => DOUT
   );

end Behavioral;

