import os
import sys

from nanoxmap import *

dir = os.path.dirname(os.path.realpath(__file__))

project = createProject(dir)

project.setVariantName('NG-MEDIUM')

project.setTopCellName('TOP_TRANSP_HIER')

project.addFiles(['src/TOP_TRANSP_HIER.vhd', 'src/TRANSP_HIER.vhd', 'src/MULT_ADD_CHAIN.vhd',])

project.setOptions({
   'MergeRegisterToPad':  'Always', # 'Never', # 'Always',
   'ManageUnconnectedSignals': 'Ground',
   })

project.addPad('DIN[0]', {'location': 'IOB10_D01P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[1]', {'location': 'IOB10_D01N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[2]', {'location': 'IOB10_D02P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[3]', {'location': 'IOB10_D02N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[4]', {'location': 'IOB10_D03P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[5]', {'location': 'IOB10_D03N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[6]', {'location': 'IOB10_D04P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[7]', {'location': 'IOB10_D04N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[8]', {'location': 'IOB10_D05P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[9]', {'location': 'IOB10_D05N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[10]', {'location': 'IOB10_D06P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[11]', {'location': 'IOB10_D06N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[12]', {'location': 'IOB10_D07P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[13]', {'location': 'IOB10_D07N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[14]', {'location': 'IOB10_D08P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[15]', {'location': 'IOB10_D08N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[16]', {'location': 'IOB10_D09P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[17]', {'location': 'IOB10_D09N', 'type': 'LVCMOS_2.5V_8mA'})

project.addPad('DOUT[0]', {'location': 'IOB11_D01P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[1]', {'location': 'IOB11_D01N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[2]', {'location': 'IOB11_D02P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[3]', {'location': 'IOB11_D02N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[4]', {'location': 'IOB11_D03P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[5]', {'location': 'IOB11_D03N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[6]', {'location': 'IOB11_D04P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[7]', {'location': 'IOB11_D04N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[8]', {'location': 'IOB11_D05P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[9]', {'location': 'IOB11_D05N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[10]', {'location': 'IOB11_D06P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[11]', {'location': 'IOB11_D06N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[12]', {'location': 'IOB11_D07P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[13]', {'location': 'IOB11_D07N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[14]', {'location': 'IOB11_D08P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[15]', {'location': 'IOB11_D08N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[16]', {'location': 'IOB11_D09P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[17]', {'location': 'IOB11_D09N', 'type': 'LVCMOS_2.5V_8mA'})

project.createClock('getClockNet(CLK)', 'CLK', 5000, 0, 2500)

project.save('native.nxm')

if not project.synthesize():
    sys.exit(1)

project.save('_synthese.vhd')
project.save('synthesized.nxm')

if not project.place():
    sys.exit(1)

project.save('placed.nxm')

if not project.route():
    sys.exit(1)

project.save('routed.nxm')

analyzer = project.createAnalyzer()
analyzer.launch(50)

print 'Errors: ', getErrorCount()
print 'Warnings: ', getWarningCount()
