library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_arith.ALL;
use IEEE.STD_LOGIC_signed.ALL;

entity MULT_ADD_CHAIN is
generic (
   DIN_WIDTH : integer range 8 to 18 := 18;
   COEF_WIDTH : integer range 8 to 24 := 18
   );
port ( 
   CLK : in  STD_LOGIC;
   DIN : in std_logic_vector(DIN_WIDTH-1 downto 0);
   COEF : in std_logic_vector(COEF_WIDTH-1 downto 0);
   ADD_CHAIN_IN : in std_logic_vector(DIN_WIDTH + COEF_WIDTH + 6 downto 0);
   ADD_CHAIN_OUT : out std_logic_vector(DIN_WIDTH + COEF_WIDTH + 6 downto 0)
   );
end MULT_ADD_CHAIN;

architecture Behavioral of MULT_ADD_CHAIN is

signal DINR : std_logic_vector(DIN_WIDTH-1 downto 0);    -- 17:0
constant ZERO : std_logic_vector(DIN_WIDTH downto 0) := (others => '0');

signal MULT : std_logic_vector(DIN_WIDTH + COEF_WIDTH - 1 downto 0);
attribute NX_USE : string;
attribute NX_USE of MULT : signal is "NX_DSP";

begin

process(CLK)  begin
   if rising_edge(CLK)  then
      DINR <= DIN;
      MULT <=  DINR * COEF;
      ADD_CHAIN_OUT <= ADD_CHAIN_IN + MULT;
   end if;
end process;

end Behavioral;

