library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_arith.ALL;
use IEEE.STD_LOGIC_signed.ALL;

entity TOP_TRANSP_HIER is
generic (
   DIN_WIDTH : integer range 8 to 18 := 18;
   COEF_WIDTH : integer range 8 to 24 := 18;
   DOUT_WIDTH : integer range 8 to 50 := 18
   );
port ( 
   CLK : in  STD_LOGIC;
   DIN : in std_logic_vector(DIN_WIDTH-1 downto 0);
   DOUT : out std_logic_vector(DOUT_WIDTH-1 downto 0)
   );
end TOP_TRANSP_HIER;

architecture Behavioral of TOP_TRANSP_HIER is

signal DIN_IO, DINR : std_logic_vector(DIN_WIDTH-1 downto 0);
signal DOUT_INT, DOUTR : std_logic_vector(DOUT_WIDTH-1 downto 0);

component TRANSP_HIER 
generic (
   DIN_WIDTH : integer range 8 to 18 := 18;
   COEF_WIDTH : integer range 8 to 24 := 18;
   DOUT_WIDTH : integer range 8 to 50 := 18
   );
port ( 
   CLK : in  STD_LOGIC;
   DIN : in std_logic_vector(DIN_WIDTH-1 downto 0);
   DOUT : out std_logic_vector(DOUT_WIDTH-1 downto 0)
   );
end component;

begin

-- IO and tile registers on DIN
process(CLK)  begin
   if rising_edge(CLK)  then
      DIN_IO <= DIN;
      DINR <= DIN_IO;
   end if;   
end process;

FILTRE :  TRANSP_HIER 
generic map (
   DIN_WIDTH  =>  DIN_WIDTH,
   COEF_WIDTH => COEF_WIDTH,
   DOUT_WIDTH => DOUT_WIDTH
   )
port map ( 
   CLK  => CLK,
   DIN  => DINR,
   DOUT => DOUT_INT
   );      


-- Tile and IO registers on DOUT
process(CLK)  begin
   if rising_edge(CLK)  then
      DOUTR <= DOUT_INT;
      DOUT <= DOUTR;
   end if;   
end process;      

end Behavioral;

