import os
import sys

from nanoxmap import *

dir = os.path.dirname(os.path.realpath(__file__))

project = createProject(dir)

project.setVariantName('NG-MEDIUM')

project.setTopCellName('transpose_sym_flat')

project.addFiles(['src/transpose_sym_flat.vhd',])

project.setOptions({
   'MappingEffort': 'Medium',
   'MergeRegisterToPad':  'Always', # 'Never', # 'Always',
   'ManageUnconnectedSignals': 'Ground',
   'TimingDriven': 'Yes'
   })

project.addPad('DIN[0]', {'location': 'IOB0_D01P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[1]', {'location': 'IOB0_D01N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[2]', {'location': 'IOB0_D02P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[3]', {'location': 'IOB0_D02N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[4]', {'location': 'IOB0_D03P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[5]', {'location': 'IOB0_D03N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[6]', {'location': 'IOB0_D04P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[7]', {'location': 'IOB0_D04N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[8]', {'location': 'IOB0_D05P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[9]', {'location': 'IOB0_D05N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[10]', {'location': 'IOB0_D06P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DIN[11]', {'location': 'IOB0_D06N', 'type': 'LVCMOS_2.5V_8mA'})

project.addPad('DOUT[0]', {'location': 'IOB12_D01P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[1]', {'location': 'IOB12_D01N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[2]', {'location': 'IOB12_D02P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[3]', {'location': 'IOB12_D02N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[4]', {'location': 'IOB12_D03P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[5]', {'location': 'IOB12_D03N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[6]', {'location': 'IOB12_D04P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[7]', {'location': 'IOB12_D04N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[8]', {'location': 'IOB12_D05P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[9]', {'location': 'IOB12_D05N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[10]', {'location': 'IOB12_D06P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[11]', {'location': 'IOB12_D06N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[12]', {'location': 'IOB12_D07P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[13]', {'location': 'IOB12_D07N', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[14]', {'location': 'IOB12_D08P', 'type': 'LVCMOS_2.5V_8mA'})
project.addPad('DOUT[15]', {'location': 'IOB12_D08N', 'type': 'LVCMOS_2.5V_8mA'})


project.createClock('getClockNet(CLK)', 'CLK', 5800, 0, 2900)

project.save('native.nxm')

if not project.synthesize():
    sys.exit(1)

project.save('TRANSPOSE_SYM_FLAT_synth.vhd')
project.save('synthesized.nxm')

if not project.place():
    sys.exit(1)

project.save('placed.nxm')

if not project.route():
    sys.exit(1)

project.save('routed.nxm')
project.save('routed.vhd')
project.save('routed.sdf')

analyzer = project.createAnalyzer()
analyzer.launch(50)

print 'Errors: ', getErrorCount()
print 'Warnings: ', getWarningCount()
