library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_arith.ALL;
use IEEE.STD_LOGIC_signed.ALL;

entity PREAD_MULT_ADD_CHAIN is
generic (
   DIN_WIDTH : integer range 8 to 18 := 18;
   COEF_WIDTH : integer range 8 to 24 := 18
   );
port ( 
   CLK : in  STD_LOGIC;
   DINL : in std_logic_vector(DIN_WIDTH-1 downto 0);
   DINR : in std_logic_vector(DIN_WIDTH-1 downto 0);
   D_CHAIN : out std_logic_vector(DIN_WIDTH-1 downto 0);
   COEF : in std_logic_vector(COEF_WIDTH-1 downto 0);
   ADD_CHAIN_IN : in std_logic_vector(DIN_WIDTH + COEF_WIDTH + 6 downto 0);
   ADD_CHAIN_OUT : out std_logic_vector(DIN_WIDTH + COEF_WIDTH + 6 downto 0)
   );
end PREAD_MULT_ADD_CHAIN;

architecture Behavioral of PREAD_MULT_ADD_CHAIN is

signal DINL_R1, DINL_R2, DINR_R : std_logic_vector(DIN_WIDTH-1 downto 0);    -- 17:0
signal PREAD : std_logic_vector(DIN_WIDTH downto 0);
constant ZERO : std_logic_vector(DIN_WIDTH downto 0) := (others => '0');

signal MULT : std_logic_vector(DIN_WIDTH + COEF_WIDTH downto 0);

begin

process(CLK)  begin
   if rising_edge(CLK)  then
      DINL_R1 <= DINL;
      DINL_R2 <= DINL_R1; 
      DINR_R <= DINR;
      PREAD <= ZERO + DINL_R2 + DINR_R;
      MULT <=  PREAD * COEF;
      ADD_CHAIN_OUT <= ADD_CHAIN_IN + MULT;
   end if;
end process;

D_CHAIN <= DINL_R2;

end Behavioral;

