library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_arith.ALL;
use IEEE.STD_LOGIC_signed.ALL;  

entity SMULT_24x30_NG_MEDIUM_FLAT is
port ( 
   CLK : in  STD_LOGIC;
   A : in  STD_LOGIC_VECTOR (23 downto 0);
   B : in  STD_LOGIC_VECTOR (29 downto 0);
   ROUND_VAL : in  STD_LOGIC_VECTOR (35 downto 0);
   MULT : out  STD_LOGIC_VECTOR (53 downto 0)
   );
end SMULT_24x30_NG_MEDIUM_FLAT;

architecture Behavioral of SMULT_24x30_NG_MEDIUM_FLAT is

-- Signals for the LSB part of the 24x30 multiplier
signal B_EXT : std_logic_vector(12 downto 0);
signal B_LSB_R : std_logic_vector(12 downto 0); -- Registered '0' & B(11:0) (must be unsigned)
signal AR : std_logic_vector(23 downto 0); -- Registered A for DSP_LSB
signal MULT_LSB : std_logic_vector(36 downto 0); -- 37-bit multiplication result (MSB can be safely ignored)
                                                 -- as it's a replication of the bit(35)
attribute NX_USE : string;
attribute NX_USE of MULT_LSB : signal is "NX_DSP";
                                                 
signal MULT_LSB_ROUND : std_logic_vector(36 downto 0); -- Includes optional rounding offset
signal MULT_LSB_R : std_logic_vector(11 downto 0);  -- 12 LSB of the global result
                                                 
-- Signals for the MSB part of the 24x30 multiplier
signal B_MSB_R1, B_MSB_R2 : std_logic_vector(17 downto 0); -- Registered B(29:12) (signed)
signal AR1, AR2 : std_logic_vector(23 downto 0); -- Registered A for DSP_MSB
signal MULT_MSB : std_logic_vector(41 downto 0); -- 43-bit multiplication result 
attribute NX_USE of MULT_MSB : signal is "NX_DSP";

signal MULT_MSB_SUM : std_logic_vector(41 downto 0); -- 43-bit result of MULT_MSB + MULT_LSB 

begin

B_EXT <= '0' & B(11 downto 0);
-- DSP for LSBs
process(CLK)  begin
   if rising_edge(CLK)  then
      B_LSB_R <= B_EXT;
      AR <= A;
      MULT_LSB <= AR * B_LSB_R;
      MULT_LSB_ROUND <= MULT_LSB + ROUND_VAL;
   end if;
end process;

-- Tile registers for LSBs of the global result
process(CLK)  begin
   if rising_edge(CLK)  then
      MULT_LSB_R <= MULT_LSB_ROUND(11 downto 0);   
   end if;
end process;

-- DSP for MSBs
process(CLK)  begin
   if rising_edge(CLK)  then
      B_MSB_R1 <= B(29 downto 12);
      B_MSB_R2 <= B_MSB_R1;
      AR1 <= A;
      AR2 <= AR1;
      MULT_MSB <= B_MSB_R2 * AR2;
      MULT_MSB_SUM <= MULT_MSB + MULT_LSB_ROUND(35 downto 12);
   end if;
end process;

MULT <= MULT_MSB_SUM & MULT_LSB_R;

end Behavioral;

