import os
import sys

from nanoxmap import *

dir = os.path.dirname(os.path.realpath(__file__))

project = createProject(dir)

project.setVariantName('NG-MEDIUM')

project.setTopCellName('SMULT_24x30_NG_MEDIUM_HIER')

project.addFiles(['src/SMULT_24x30_NG_MEDIUM_HIER.vhd', 'src/SMULT_24x12_HIER.vhd', 'src/SMULT_24x18_HIER.vhd', ])

project.setOptions({
   'MergeRegisterToPad':  'Never', # 'Always',
   'ManageUnconnectedSignals': 'Ground',
   })

project.createClock('getClockNet(CLK)', 'CLK', 4000, 0, 2000)

project.save('native.nxm')

if not project.synthesize():
    sys.exit(1)

project.save('_synthese.vhd')
project.save('synthesized.nxm')

if not project.place():
    sys.exit(1)

project.save('placed.nxm')

if not project.route():
    sys.exit(1)

project.save('routed.nxm')

analyzer = project.createAnalyzer()
analyzer.launch(1000)

print 'Errors: ', getErrorCount()
print 'Warnings: ', getWarningCount()
