library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_arith.ALL;
use IEEE.STD_LOGIC_signed.ALL;  
-- The 12 LSBs of B(29:0) will have a '0' extension  unsigned to be treated as Unsigned

entity SMULT_24x12_HIER is
port ( 
   CLK            : in std_logic;
   A              : in std_logic_vector(23 downto 0);
   B              : in std_logic_vector(12 downto 0);
   ROUND_VAL      : in std_logic_vector(35 downto 0);
   MULT_LSB_ROUND : out std_logic_vector(36 downto 0)
   );
end SMULT_24x12_HIER;

architecture Behavioral of SMULT_24x12_HIER is

signal AR : std_logic_vector(23 downto 0);
signal B_LSB_R : std_logic_vector(12 downto 0);

signal MULT_LSB : std_logic_vector(36 downto 0);
attribute NX_USE : string;
attribute NX_USE of MULT_LSB : signal is "NX_DSP";

begin

process(CLK)  begin
   if rising_edge(CLK)  then
      AR <= A;
      B_LSB_R <= B;
      MULT_LSB <= AR * B_LSB_R;
      MULT_LSB_ROUND <= MULT_LSB + ROUND_VAL;
   end if;
end process;

end Behavioral;

