library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_arith.ALL;
use IEEE.STD_LOGIC_signed.ALL;  
       
entity SMULT_24x18_HIER is
port ( 
   CLK            : in std_logic;
   A              : in std_logic_vector(23 downto 0);
   B              : in std_logic_vector(17 downto 0);
   MULT_LSB_ROUND : in std_logic_vector(23 downto 0);
   MULT_MSB_SUM   : out std_logic_vector(41 downto 0)
   );
end SMULT_24x18_HIER;

architecture Behavioral of SMULT_24x18_HIER is

signal AR1, AR2 : std_logic_vector(23 downto 0);
signal B_MSB_R1, B_MSB_R2 : std_logic_vector(17 downto 0);

signal MULT_MSB : std_logic_vector(41 downto 0);
attribute NX_USE : string;
attribute NX_USE of MULT_MSB : signal is "NX_DSP";

begin

process(CLK)  begin
   if rising_edge(CLK)  then
      AR1  <= A;
      AR2 <= AR1;
      B_MSB_R1 <= B;
      B_MSB_R2 <= B_MSB_R1;
      MULT_MSB <= AR2 * B_MSB_R2;
      MULT_MSB_SUM <= MULT_MSB + MULT_LSB_ROUND;
   end if;
end process;

end Behavioral;

