library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_arith.ALL;
use IEEE.STD_LOGIC_signed.ALL;  

entity SMULT_24x30_NG_MEDIUM_HIER is
port ( 
   CLK       : in  STD_LOGIC;
   A         : in  STD_LOGIC_VECTOR (23 downto 0);
   B         : in  STD_LOGIC_VECTOR (29 downto 0);
   ROUND_VAL : in  STD_LOGIC_VECTOR (35 downto 0);
   MULT      : out  STD_LOGIC_VECTOR (53 downto 0)
   );
end SMULT_24x30_NG_MEDIUM_HIER;

architecture Behavioral of SMULT_24x30_NG_MEDIUM_HIER is

signal B_EXT : std_logic_vector(12 downto 0);

component SMULT_24x12_HIER 
port ( 
   CLK            : in std_logic;
   A              : in std_logic_vector(23 downto 0);
   B              : in std_logic_vector(12 downto 0);
   ROUND_VAL      : in std_logic_vector(35 downto 0);
   MULT_LSB_ROUND : out std_logic_vector(36 downto 0)
   );
end component;
signal MULT_LSB_ROUND : std_logic_vector(36 downto 0);
signal MULT_LSB_R : std_logic_vector(11 downto 0);

component SMULT_24x18_HIER 
port ( 
   CLK            : in std_logic;
   A              : in std_logic_vector(23 downto 0);
   B              : in std_logic_vector(17 downto 0);
   MULT_LSB_ROUND : in std_logic_vector(23 downto 0);
   MULT_MSB_SUM   : out std_logic_vector(41 downto 0)
   );
end component;
signal MULT_MSB_SUM : std_logic_vector(41 downto 0);


begin

B_EXT <= '0' & B(11 downto 0);

-- DSP for LSBs
DSPLSB : SMULT_24x12_HIER 
port map( 
   CLK            => CLK,
   A              => A,
   B              => B_EXT,
   ROUND_VAL      => ROUND_VAL,
   MULT_LSB_ROUND => MULT_LSB_ROUND
   );

-- Tile registers for LSBs of the global result
process(CLK)  begin
   if rising_edge(CLK)  then
      MULT_LSB_R <= MULT_LSB_ROUND(11 downto 0);   
   end if;
end process;

-- DSP for MSBs
DSPMSB : SMULT_24x18_HIER 
port map( 
   CLK            => CLK,
   A              => A,
   B              => B(29 downto 12),
   MULT_LSB_ROUND => MULT_LSB_ROUND(35 downto 12),
   MULT_MSB_SUM   => MULT_MSB_SUM
   );
   
MULT <= MULT_MSB_SUM & MULT_LSB_R;

end Behavioral;

