library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

library NX;
use NX.nxPackage.all;

entity ckb is
    port(
        CK : in  std_logic;
        I  : in  std_logic;
        O  : out std_logic
    );
end entity;

architecture rtl of ckb is
    signal ckb_i : std_logic;
    signal ckb_o : std_logic;

begin
    CKB_0 : NX_CKB
    port map (
        I => ckb_i,
        O => ckb_o
    );

    process (CK)
    begin
        if (CK'event and CK='1') then
            ckb_i <= not ckb_i;
        end if;
    end process;

    process (ckb_o)
    begin
        if(ckb_o'event and ckb_o='1') then
            O <= I;
        end if;
    end process;

end architecture;
