library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

library NX;
use NX.nxPackage.all;

entity adder is
    port(
        A   : in std_logic_vector(3 downto 0);
        B   : in std_logic_vector(1 downto 0);
        SUM : out std_logic_vector(3 downto 0)
    );
end entity;

architecture rtl of adder is

begin

-- SUM[3:0] <= A[3:0] + ”10”&B[1:0]

CY_0 : NX_CY
generic map (
      add_carry  => 0                       -- low
    , add_table1 => b"1100110011001100"     -- O <= I2
    , add_table2 => b"1010101010101010"     -- O <= I1
    , add_table3 => b"0000000000000000"     -- O <= ‘0’
    , add_table4 => b"1111111111111111"     -- O <= ‘1’
)
port map (
      A1  => A(0), B1I1 => OPEN, B1I2 => B(0), B1I3 => OPEN, B1I4 => OPEN
    , A2  => A(1), B2I1 => B(1), B2I2 => OPEN, B2I3 => OPEN, B2I4 => OPEN
    , A3  => A(2), B3I1 => OPEN, B3I2 => OPEN, B3I3 => OPEN, B3I4 => OPEN
    , A4  => A(3), B4I1 => OPEN, B4I2 => OPEN, B4I3 => OPEN, B4I4 => OPEN
    , CIB => OPEN, COB => OPEN
    , O1  => SUM(0), O2 => SUM(1), O3 => SUM(2), O4 => SUM(3)
);

end architecture;
