Library IEEE;
use IEEE.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.std_logic_unsigned.all;

library NX;
use NX.nxPackage.all;

entity hdpecc_4Kx32 is
	port(
		ckw : in std_logic;
		ckr : in std_logic;
		ckq : in std_logic;
		we  : in std_logic;
		adw : in std_logic_vector (11 downto 0);
		adr : in std_logic_vector (11 downto 0);
		di  : in std_logic_vector (31 downto 0);
		do  : out std_logic_vector (31 downto 0);
		cor : out std_logic;
		err : out std_logic
	);
end entity;

architecture rtl of hdpecc_4Kx32 is 
	type mem_reg is array (4095 downto 0) of std_logic_vector(31 downto 0);
	signal mem : mem_reg;

	begin

	hdpram_ecc: NX_ECC
	 port map (
		CKD => ckq,
		CHK => do(0),
		COR => cor,
		ERR => err
	 );

	 process (ckr)
	 begin
	 if (rising_edge (ckr)) then
		do <= mem(to_integer(unsigned(adr)));
	end if;
	end process;

	 process (ckw)
	 begin
	 if (rising_edge (ckw)) then
	    if (we='1') then
		mem((to_integer(unsigned(adw)))) <= di;
	    end if;
	end if;
	end process;

end architecture;
