library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

library NX;
use NX.nxPackage.all;

entity fe is
    port(
	A	:   in std_logic;
	B	:   in std_logic;
	C	:   in std_logic;
	D	:   in std_logic;
	O	:   out std_logic;
	CLK	:   in std_logic;
	R	:   in std_logic;
	L	:   in std_logic
    );
end entity;

architecture rtl of fe is

begin

DFF_0 : NX_FE
generic map (
      lut_table => b"1111111111111110" -- O <= A | B | C | D
    , dff_mode  => '1'                 -- sequential mode
    , dff_edge  => '0'                 -- rising edge
    , dff_load  => '0'                 -- always load
    , dff_init  => '1'                 -- use connected reset net
    , dff_sync  => '1'                 -- synchronous reset
    , dff_ctxt  => '0'                 -- initial value is 0
)
port map (
      I1 => A
    , I2 => B
    , I3 => C
    , I4 => D
    , O  => O
    , CK => CLK
    , R  => R
    , L  => L
);

end architecture;
