import os
import sys

from nanoxmap import *

dir = str(os.path.dirname(os.path.realpath(__file__)))

project = createProject(dir)

project.setVariantName('NG-MEDIUM')

project.setTopCellName('pll')

project.addFile('src/pll.vhd')

project.setOptions({
  'UseNxLibrary': 'Yes'
})

import NX1H35_EK_V1

kit = NX1H35_EK_V1.Kit()

pads = { 'ck25MHz':   kit.pad('OSC0')
       , 'ck12_5MHz': kit.pad('TP1_2')
       , 'ck50MHz':   kit.pad('TP1_3')
       , 'ready':     kit.pad('LED1')
}

project.addPads(pads)

project.save('native.nxm')

if not project.synthesize():
    sys.exit(1)

project.save('synthesized.nxm')

if not project.place():
    sys.exit(1)

project.save('placed.nxm')

if not project.route():
    sys.exit(1)

project.save('routed.nxm')

#report
project.reportInstances()

#bitstream
project.generateBitstream('pll.nxb')

print 'Errors: ', getErrorCount()
print 'Warnings: ', getWarningCount()
