library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

library NX;
use NX.nxPackage.all;

entity rfb is
    port(
	CLK	:   in std_logic;
	DI	:   in std_logic_vector(15 downto 0);
	DO	:   out std_logic_vector(15 downto 0);
	RA	:   in std_logic_vector(5 downto 0);
	WA	:   in std_logic_vector(5 downto 0);
	WE	:   in std_logic;
	COR	:   out std_logic;
	ERR	:   out std_logic
    );
end entity;

architecture rtl of rfb is

begin

-- RFB 64 words of 16 bits

RFB_0 : NX_RFB
generic map (
      ren_table => b"1111111111111111" -- O <= '1'
    , wen_table => b"1010101010101010" -- O <= I1
    , mem_ctxt  => "1111111111111111,0011001100110011," &
		      "1100110011001100,1111111111111111," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000," &
		      "0000000000000000,0000000000000000"
)
port map (
      RCK => CLK
    , WCK => CLK
    , I1  => DI(0)
    , I2  => DI(1)
    , I3  => DI(2)
    , I4  => DI(3)
    , I5  => DI(4)
    , I6  => DI(5)
    , I7  => DI(6)
    , I8  => DI(7)
    , I9  => DI(8)
    , I10 => DI(9)
    , I11 => DI(10)
    , I12 => DI(11)
    , I13 => DI(12)
    , I14 => DI(13)
    , I15 => DI(14)
    , I16 => DI(15)
    , COR => COR
    , ERR => ERR
    , O1  => DO(0)
    , O2  => DO(1)
    , O3  => DO(2)
    , O4  => DO(3)
    , O5  => DO(4)
    , O6  => DO(5)
    , O7  => DO(6)
    , O8  => DO(7)
    , O9  => DO(8)
    , O10 => DO(9)
    , O11 => DO(10)
    , O12 => DO(11)
    , O13 => DO(12)
    , O14 => DO(13)
    , O15 => DO(14)
    , O16 => DO(15)
    , RA1 => RA(0)
    , RA2 => RA(1)
    , RA3 => RA(2)
    , RA4 => RA(3)
    , RA5 => RA(4)
    , RA6 => RA(5)
    , WA1 => WA(0)
    , WA2 => WA(1)
    , WA3 => WA(2)
    , WA4 => WA(3)
    , WA5 => WA(4)
    , WA6 => WA(5)
    , RE1 => OPEN
    , RE2 => OPEN
    , RE3 => OPEN
    , RE4 => OPEN
    , WE1 => WE
    , WE2 => OPEN
    , WE3 => OPEN
    , WE4 => OPEN
);

end architecture;
