import os
import sys

from nanoxmap import *

dir = str(os.path.dirname(os.path.realpath(__file__)))

project = createProject(dir)

project.setVariantName('NG-MEDIUM')

project.setTopCellName('wfg')

project.addFile('src/wfg.vhd')

project.setOptions({
  'UseNxLibrary': 'Yes'
})

if os.path.exists('pads.py'):
    from pads import pads
    project.addPads(pads)

project.save('native.nxm')

if not project.synthesize():
    sys.exit(1)

project.save('synthesized.nxm')

if not project.place():
    sys.exit(1)

project.save('placed.nxm')

if not project.route():
    sys.exit(1)

project.save('routed.nxm')

#report
project.reportInstances()

#bitstream
project.generateBitstream('wfg.nxb')

print 'Errors: ', getErrorCount()
print 'Warnings: ', getWarningCount()
