library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

library NX;
use NX.nxPackage.all;

entity wfg is
    port(
	CK50MHz	:   in std_logic;
	NOTCK	:   out std_logic;
	CK25MHz	:   out std_logic
    );
end entity;

architecture rtl of wfg is

begin

-- RFB 64 words of 16 bits
-- CK50MHz at 50 MHz
--   NOTCK   = ~CK50MHz
--   CK25MHz = CK50MHz / 2

    WFG_0 : NX_WFG
    generic map (
	wfg_edge => '1'
    )
    port map (
	  SI => OPEN
	, SO => OPEN
	, RDY => OPEN
	, ZI => CK50MHz
	, ZO => NOTCK
);

    WFG_1 : NX_WFG
    generic map (
	  mode    => '1'
	, pattern_end  => 1
	, pattern => b"1000000000000000"
    )
    port map (
	  SI => OPEN
	, SO => OPEN
	, RDY => OPEN
	, ZI => CK50MHz
	, ZO => CK25MHz
);

end architecture;
