Library IEEE;
use IEEE.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.std_logic_unsigned.all;

library NX;
use NX.nxPackage.all;

entity iob is 
    port (
	A : in std_logic;
	B : in std_logic;
	C : in std_logic;
	S1 : out std_logic; 
	S2 : out std_logic; 
	S3 : inout std_logic 
    );
end entity;

architecture rtl of iob is
    signal ia : std_logic;
    signal ib : std_logic;
    signal ic : std_logic;
    signal os1 : std_logic;
    signal os2 : std_logic;
    signal os3 : std_logic;
    signal is3 : std_logic;
    signal cs3 : std_logic;
    signal ts3 : std_logic;

begin

    os1 <= ia and is3;
    os2 <= ia and ib;
    os3 <= ia and ic;
    cs3 <= ib and ic;
    ts3 <= ib and not ic;

  iob_s3 : NX_IOB
	port map (
	    I  => os3,
	    C  => cs3,
	    T  => ts3,
	    O  => is3,
	    IO => S3
	);

    iob_a : NX_IOB_I
	port map (
	    T  => '1',
	    O  => ia,
	    IO => A
	);

    iob_b : NX_IOB_I
	port map (
	    T  => '1',
	    O  => ib,
	    IO => B
	);

    iob_c : NX_IOB_I
	port map (
	    T  => '1',
	    O  => ic,
	    IO => C
	);

    iob_s1 : NX_IOB_O
	port map (
	    I  => os1,
	    C  => '1',
	    T  => '0',
	    IO => S1
	);

    iob_s2 : NX_IOB_O
	port map (
	    I  => os2,
	    C  => '0',
	    T  => '0',
	    IO => S2
	);

end architecture;	
