import os
import sys

from nanoxmap import *

dir = str(os.path.dirname(os.path.realpath(__file__)))

project = createProject(dir)

project.setVariantName('NG-MEDIUM')

project.setTopCellName('TOP_CKG_320')

project.addFile('src/TOP_CKG_320.vhd')
project.addFiles(['src/COUNTLOGIC.vhd',
                  'src/CKG_MODULE_320.vhd'
                 ])

project.setOptions({
   'UseNxLibrary': 'Yes',
   'MergeRegisterToPad': 'Always', #'Never', #'Always',
   'MultiplierToDSPMapThreshold': '25',
   'ManageUnconnectedOutputs': 'Ground',
   'ManageUnconnectedSignals': 'Ground',
   'AdderToDSPMapThreshold': '25',
   'DefaultRAMMapping': 'RAM', # 'RF'
   'MappingEffort': 'High'})


##################################################################################################
# Constraining clocks
##################################################################################################
project.createClock('getClockNet(CLKIN_80)', 'CLKIN_80', 12500, 0, 6250)

##################################################################################################
# Syntax examples to ignore timimg on clock domain change
##################################################################################################
#project.setClockGroup('getClock(CLK_80)', 'getClock(CLK_40)', 'asynchronous')
#project.setClockGroup('getClock(CLK_80)', 'getClock(CLK_160)', 'asynchronous')
#project.setClockGroup('getClock(CLK_40)', 'getClock(CLK_80)', 'exclusive')
#project.setClockGroup('getClock(CLK_80)', 'getClock(CLKIN_80)', 'exclusive')


##################################################################################################
# Specifying external destinations timing requirement (setup time of the destination)
##################################################################################################
#project.setOutputDelay('getClock(CLKIN_80)', 'rise', 1000, 2500, 'getPort(CNT_R_160[0])')  # bit per bit
#project.setOutputDelay('getClock(CLKIN_80)', 'rise', 1000, 2500, 'getPort(CNT_R_160[1])')
#project.setOutputDelay('getClock(CLKIN_80)', 'rise', 1000, 2500, 'getPort(CNT_R_160[2])')
#project.setOutputDelay('getClock(CLKIN_80)', 'rise', 1000, 2500, 'getPort(CNT_R_160[3])')
#project.setOutputDelay('getClock(CLKIN_80)', 'rise', 1000, 2500, 'getPort(CNT_R_160[4])')
#project.setOutputDelay('getClock(CLKIN_80)', 'rise', 1000, 2500, 'getPort(CNT_R_160[5])')
#project.setOutputDelay('getClock(CLKIN_80)', 'rise', 1000, 2500, 'getPort(CNT_R_160[6])')
#project.setOutputDelay('getClock(CLKIN_80)', 'rise', 1000, 2500, 'getPort(CNT_R_160[7])')

project.setOutputDelay('getClock(CLKIN_80)', 'rise', 1000, 1500, "getPorts(CNT_R_160\[[0-7]\])") # For a bus

project.setOutputDelay('getClock(CLKIN_80)', 'rise', 1000, 3500, 'getPort(CNT_R_40[0])')
project.setOutputDelay('getClock(CLKIN_80)', 'rise', 1000, 2500, 'getPort(CNT_R_80[0])')


##################################################################################################
# Specifying pads location and electrical parameters
##################################################################################################
project.addPads({
  'CNT_R_160[0]'    : {'location': 'IOB09_D01P', 'type': 'LVCMOS_2.5V_4mA', 'outputDelayLine': 13, 'weakTermination': 'PullDown', 'slewRate': 'Slow'},
  'CNT_R_160[1]'    : {'location': 'IOB09_D01N', 'type': 'LVCMOS_2.5V_4mA'},
  'CNT_R_160[2]'    : {'location': 'IOB09_D02P', 'type': 'LVCMOS_2.5V_4mA'},
  'CNT_R_160[3]'    : {'location': 'IOB09_D02N', 'type': 'LVCMOS_2.5V_4mA'},
  'CNT_R_160[4]'    : {'location': 'IOB09_D03P', 'type': 'LVCMOS_2.5V_4mA'},
  'CNT_R_160[5]'    : {'location': 'IOB09_D03N', 'type': 'LVCMOS_2.5V_4mA'},
  'CNT_R_160[6]'    : {'location': 'IOB09_D04P', 'type': 'LVCMOS_2.5V_4mA'},
  'CNT_R_160[7]'    : {'location': 'IOB09_D04N', 'type': 'LVCMOS_2.5V_4mA'},
  'TCOUT_R_160'     : {'location': 'IOB09_D05P', 'type': 'LVCMOS_2.5V_4mA'},

  'CNT_R_80[0]'    : {'location': 'IOB09_D06P', 'type': 'LVCMOS_2.5V_4mA'},
  'CNT_R_80[1]'    : {'location': 'IOB09_D06N', 'type': 'LVCMOS_2.5V_4mA'},
  'CNT_R_80[2]'    : {'location': 'IOB09_D07P', 'type': 'LVCMOS_2.5V_4mA'},
  'CNT_R_80[3]'    : {'location': 'IOB09_D07N', 'type': 'LVCMOS_2.5V_4mA'},
  'CNT_R_80[4]'    : {'location': 'IOB09_D08P', 'type': 'LVCMOS_2.5V_4mA'},
  'CNT_R_80[5]'    : {'location': 'IOB09_D08N', 'type': 'LVCMOS_2.5V_4mA'},
  'CNT_R_80[6]'    : {'location': 'IOB09_D09P', 'type': 'LVCMOS_2.5V_4mA'},
  'CNT_R_80[7]'    : {'location': 'IOB09_D09N', 'type': 'LVCMOS_2.5V_4mA'},
  'TCOUT_R_80'     : {'location': 'IOB09_D10P', 'type': 'LVCMOS_2.5V_4mA'},

  'CNT_R_40[0]'    : {'location': 'IOB09_D11P', 'type': 'LVCMOS_2.5V_4mA', 'outputDelayLine': 13, 'weakTermination': 'PullDown', 'slewRate': 'Fast'},
  'CNT_R_40[1]'    : {'location': 'IOB09_D11N', 'type': 'LVCMOS_2.5V_4mA', 'outputDelayLine': 7, 'weakTermination': 'Keeper', 'slewRate': 'Slow'},
  'CNT_R_40[2]'    : {'location': 'IOB09_D12P', 'type': 'LVCMOS_2.5V_4mA'},
  'CNT_R_40[3]'    : {'location': 'IOB09_D12N', 'type': 'LVCMOS_2.5V_4mA'},
  'CNT_R_40[4]'    : {'location': 'IOB09_D13P', 'type': 'LVCMOS_2.5V_4mA'},
  'CNT_R_40[5]'    : {'location': 'IOB09_D13N', 'type': 'LVCMOS_2.5V_4mA'},
  'CNT_R_40[6]'    : {'location': 'IOB09_D14P', 'type': 'LVCMOS_2.5V_4mA'},
  'CNT_R_40[7]'    : {'location': 'IOB09_D14N', 'type': 'LVCMOS_2.5V_4mA'},
  'TCOUT_R_40'     : {'location': 'IOB09_D15P', 'type': 'LVCMOS_2.5V_4mA'},

  'CLKIN_80'       : {'location': 'IOB08_D01P', 'type': 'LVCMOS_2.5V_4mA'},
  })


##################################################################################################
# Pogrammation
##################################################################################################

project.save('native.nxm')

if not project.synthesize():
    sys.exit(1)
project.save('_synthese.vhd')
project.save('synthesized.nxm')

if not project.place():
    sys.exit(1)

project.save('placed.nxm')

if not project.route():
    sys.exit(1)

project.save('routed.nxm')


##################################################################################################
# Static Timimg Analyzer
##################################################################################################
#STA
STA_parameters = {'searchPathLimit': 15, 'temperature': 125}
analyzer = project.createAnalyzer()
analyzer.launch(STA_parameters) # Launches the timing analyzer on the &( worst paths on each domain at temperature = 125

print 'Errors: ', getErrorCount()
print 'Warnings: ', getWarningCount()

project.save('_routed_design.vhd')


##################################################################################################
# Simulation
##################################################################################################
#simulator = project.createSimulator()

#simulator.addTestBench('src/TB_TOP_CKG_320.vhd')
#simulator.setTestBenchTop('TB_TOP_CKG_320')
#simulator.setWorkingDirectory('simu')
#simulator.addWave('*')

#simulator.launch('100us', True)


##################################################################################################
# Bitstream generation
##################################################################################################
project.generateBitstream('TOP_PLL_320.nxb')


##################################################################################################
# Destroy project
##################################################################################################
project.destroy()
