
 library IEEE;
 use IEEE.STD_LOGIC_1164.ALL;
 
 library NX;
 use NX.nxpackage.all;
 
 entity CKG_MODULE_320 is
    generic(simu : boolean := false);
    Port ( 
    REF : in  STD_LOGIC;
    CLK_160 : out  STD_LOGIC;
    CLK_80 : out  STD_LOGIC;
    CLK_40 : out  STD_LOGIC;
    RST : out  STD_LOGIC;
    OSC : out std_logic
    );
 end CKG_MODULE_320;
 
 architecture Behavioral of CKG_MODULE_320 is
 
 signal VCO_320 : std_logic;
 signal RDY : std_logic;
 signal FBK : std_logic;
 signal SO : std_logic;
 signal RST_DELAY : std_logic_vector(3 downto 0); 
 
 begin
    INST_PLL: NX_PLL 
    generic map (
       vco_range    => 0,
       ref_div_on   => '0',
       fbk_div_on   => '0',  
       
       ext_fbk_on   => '1',  
       fbk_intdiv   => 4,    
 
       fbk_delay_on => '0',
       fbk_delay    => 11,
       
       clk_outdiv1  => 1,
       clk_outdiv2  => 2,
       clk_outdiv3  => 4      
       )
    PORT MAP (
       REF => REF,
       FBK => FBK,
       VCO => VCO_320,
       D1  => open,
       D2  => open,
       D3  => open,
       OSC => OSC,
       RDY => RDY
      );
      
    INST_WFG_80 : NX_WFG
    generic map (
       mode        => '1',
       wfg_edge    => '0',
       pattern_end => 7,
       pattern     => "0110011000000000",
       delay       => 0,
       delay_on    => '0'
       )
    port map (
       RDY => open,
       SI  => SO,
       ZI  => VCO_320,
       SO  => SO,
       ZO  => FBK
       );
       
    CLK_80 <= FBK;  
     
       
    INST_WFG_160 : NX_WFG
    generic map (
       mode        => '1',
       wfg_edge    => '0',
       pattern_end => 7,
       pattern     => "0101010100000000",
       delay       => 0,
       delay_on    => '0'
       )
    port map (
       RDY => RDY,
       SI  => SO,
       ZI  => VCO_320,
       SO  => open,
       ZO  => CLK_160
       );
 
    INST_WFG_40 : NX_WFG
    generic map (
       mode        => '1',
       wfg_edge    => '0',
       pattern_end => 7,
       pattern     => "0111100000000000",
       delay       => 0,
       delay_on    => '0'
       )
    port map (
       RDY => RDY,
       SI  => SO,
       ZI  => VCO_320,
       SO  => open,
       ZO  => CLK_40
       );
 
 process(FBK)  begin
    if falling_edge(FBK)  then
       RST_DELAY <= RST_DELAY(2 downto 0) & not(RDY);
    end if;
 end process;   
 
 RST <= RST_DELAY(3);
 
 end Behavioral;
 
 