library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_arith.ALL;
use IEEE.STD_LOGIC_unsigned.ALL;

entity COUNTLOGIC is
   generic(
   Nbits : integer := 16;
   Async_rst : boolean := true
   );
   Port ( 
   CLK : in  STD_LOGIC;
   RST : in std_logic;
   ENA : in  STD_LOGIC;
   CNT_R : out  STD_LOGIC_VECTOR (Nbits-1 downto 0);
   TCOUT_R : out  STD_LOGIC
   );
end COUNTLOGIC;

architecture Behavioral of COUNTLOGIC is

signal CNT_INT : std_logic_vector(CNT_R'range);
constant MAX_VAL : std_logic_vector(CNT_R'range) := (others => '1');

signal TCOUT_INT : std_logic;

begin

GEN_ASYNC : if Async_rst  generate
   process(CLK, RST)  begin
      if RST = '1'  then
         CNT_INT <= (others => '0');
         TCOUT_INT <= '0';
      elsif rising_edge(CLK)  then
         if ENA = '1'  then
            CNT_INT <= CNT_INT + 1;
            if CNT_INT = MAX_VAL  then
               TCOUT_INT <= '1';
            else
               TCOUT_INT <= '0';
            end if;
         end if;
      end if;
   end process;
end generate;   

GEN_SYNC : if not(Async_rst)  generate
   process(CLK)  begin
      if rising_edge(CLK)  then
         if RST = '1'  then
            CNT_INT <= (others => '0');
            TCOUT_INT <= '0';
         elsif ENA = '1'  then
            CNT_INT <= CNT_INT + 1;
            if CNT_INT = MAX_VAL  then
               TCOUT_INT <= '1';
            else
               TCOUT_INT <= '0';
            end if;
         end if;
      end if;
   end process;   
end generate;

process(CLK)  begin
   if rising_edge(CLK)  then
      CNT_R <= CNT_INT;
      TCOUT_R <= TCOUT_INT;
   end if;
end process;

end Behavioral;

