LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
 
ENTITY TB_TOP_CKG_320 IS
END TB_TOP_CKG_320;
 
ARCHITECTURE behavior OF TB_TOP_CKG_320 IS 
 
    COMPONENT TOP_CKG_320
   generic (
   Nbits : integer := 8
   );
    PORT(
         CLKIN_80 : IN  std_logic;
         CNT_R_160 : OUT  std_logic_vector(7 downto 0);
         CNT_R_80 : OUT  std_logic_vector(7 downto 0);
         CNT_R_40 : OUT  std_logic_vector(7 downto 0);
         TCOUT_R_160 : OUT  std_logic;
         TCOUT_R_80 : OUT  std_logic;
         TCOUT_R_40 : OUT  std_logic
        );
    END COMPONENT;
    
   signal CLKIN_80 : std_logic := '0';

   signal CNT_R_160 : std_logic_vector(7 downto 0);
   signal CNT_R_80 : std_logic_vector(7 downto 0);
   signal CNT_R_40 : std_logic_vector(7 downto 0);
   signal TCOUT_R_160 : std_logic;
   signal TCOUT_R_80 : std_logic;
   signal TCOUT_R_40 : std_logic;

   constant CLKIN_80_period : time := 12.5 ns;
 
BEGIN
 
	-- Instantiate the Unit Under Test (UUT)
   uut: TOP_CKG_320 
   generic map (Nbits => 8)
   PORT MAP (
          CLKIN_80 => CLKIN_80,
          CNT_R_160 => CNT_R_160,
          CNT_R_80 => CNT_R_80,
          CNT_R_40 => CNT_R_40,
          TCOUT_R_160 => TCOUT_R_160,
          TCOUT_R_80 => TCOUT_R_80,
          TCOUT_R_40 => TCOUT_R_40
        );

   CLKIN_80_process :process
   begin
      wait for 3 us;
      
      for I in 0 to 100000 loop
         CLKIN_80 <= '0';
         wait for CLKIN_80_period/2;
         CLKIN_80 <= '1';
         wait for CLKIN_80_period/2;
      end loop;
   end process;
 

END;
