-- This design example shows how to generate phase controlled clocks with "zero delay" propagation
--
-- The reference clock input is CLKIN_80 (80 MHz)
--
-- A PLL (using external feedback) and 3 WFG (using (8-tap patterns) are used to generate
-- three internal clocks : CLK_160, CLK_80 and CLK_40
-- The VCO frequency is 320 MHz
-- The three internally generated clocks are phase aligned with the REF input (CLKIN_80)

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_arith.ALL;
use IEEE.STD_LOGIC_unsigned.ALL;

entity TOP_CKG_320 is
   generic (
   Nbits : integer := 8
   );
   Port (
   CLKIN_80 : in  STD_LOGIC;
   CNT_R_160 : out std_logic_vector(7 downto 0);
   CNT_R_80  : out std_logic_vector(Nbits-1 downto 0);
   CNT_R_40  : out std_logic_vector(Nbits-1 downto 0);
   TCOUT_R_160 : out  STD_LOGIC;
   TCOUT_R_80 : out  STD_LOGIC;
   TCOUT_R_40 : out  STD_LOGIC
   );
end TOP_CKG_320;

architecture Behavioral of TOP_CKG_320 is

signal VCC : std_logic;

component CKG_MODULE_320
   Port (
   REF : in  STD_LOGIC;
   CLK_160 : out  STD_LOGIC;
   CLK_80 : out  STD_LOGIC;
   CLK_40 : out  STD_LOGIC;
   RST : out  STD_LOGIC;
   OSC : out std_logic
   );
end component;

signal CLK_160, CLK_80, CLK_40 : std_logic;
signal RST : std_logic;

component COUNTLOGIC 
   generic(
   Nbits : integer := 16;
   Async_rst : boolean := true
   );
   Port (
   CLK : in  STD_LOGIC;
   RST : in std_logic;
   ENA : in  STD_LOGIC;
   CNT_R : out  STD_LOGIC_VECTOR (Nbits-1 downto 0);
   TCOUT_R : out  STD_LOGIC
   );
end component;

begin

VCC <= '1';

CKGM : CKG_MODULE_320
   Port map(
   REF     => CLKIN_80,
   CLK_160 => CLK_160,
   CLK_80  => CLK_80,
   CLK_40  => CLK_40,
   RST     => RST,
   OSC     => open
   );

CNT160 : COUNTLOGIC
   generic map (
   Nbits => 8,
   Async_rst => false
   )
   port map (
   CLK     => CLK_160,
   RST     => RST,
   ENA     => VCC,
   CNT_R   => CNT_R_160,
   TCOUT_R => TCOUT_R_160
   );

CNT80 : COUNTLOGIC
   generic map (
   Nbits => Nbits,
   Async_rst => false
   )
   port map (
   CLK     => CLK_80,
   RST     => RST,
   ENA     => VCC,
   CNT_R   => CNT_R_80,
   TCOUT_R => TCOUT_R_80
   );

CNT40 : COUNTLOGIC
   generic map (
   Nbits => Nbits,
   Async_rst => false
   )
   port map (
   CLK     => CLK_40,
   RST     => RST,
   ENA     => VCC,
   CNT_R   => CNT_R_40,
   TCOUT_R => TCOUT_R_40
   );

end Behavioral;

